package cn.freemud.demo.adapter.service;

import cn.freemud.demo.entities.bo.goods.ShoppingCartApportionBO;
import cn.freemud.demo.entities.dto.BaseApportionVO;
import cn.freemud.demo.entities.dto.MCoffeeApportionVO;
import cn.freemud.demo.entities.dto.PlatformApportionVO;
import cn.freemud.demo.enums.BizTypeEnum;
import cn.freemud.utils.BeanUtil;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class ApportionVOAdapter {

    @Resource
    private MapperFacade mapperFacade;

    public BaseApportionVO convert2ApportionVO(String bizType, ShoppingCartApportionBO baseAddGoodsBO) {
        BaseApportionVO listCartGoodsVO;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            listCartGoodsVO = createMCoffeeVO(baseAddGoodsBO);
        } else {
            listCartGoodsVO = createPlatformVO(baseAddGoodsBO);
        }
        return listCartGoodsVO;
    }


    private PlatformApportionVO createPlatformVO(ShoppingCartApportionBO baseAddGoodsBO) {

        PlatformApportionVO platformAddGoodsVO = BeanUtil.convertBean(baseAddGoodsBO, PlatformApportionVO::new);
        return platformAddGoodsVO;
    }

    private MCoffeeApportionVO createMCoffeeVO(ShoppingCartApportionBO baseAddGoodsBO) {
        MCoffeeApportionVO mCoffeeAddGoodsVO = new MCoffeeApportionVO();
        return mCoffeeAddGoodsVO;
    }

}
