/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: StoreAdapter
 * @Package cn.freemud.adapter
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/14 9:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.adapter;

import cn.freemud.entities.dto.GetBannerPictureListDto;
import cn.freemud.entities.dto.NearStoreRequestDto;
import cn.freemud.entities.dto.StoreImagesRequestDto;
import cn.freemud.entities.dto.StoreResponseDto;
import cn.freemud.entities.vo.NearStoreRequest;
import cn.freemud.entities.vo.NearStoreResponseVo;
import cn.freemud.entities.vo.StoreInfoResponseVo;
import cn.freemud.utils.BeanUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class StoreAdapter {

    public NearStoreRequestDto convertNearStoreRequestDto(NearStoreRequest request) {
        NearStoreRequestDto nearStoreRequestDto = BeanUtil.convertBean(request, NearStoreRequestDto::new);
        nearStoreRequestDto.setActiveFlag("1");
        nearStoreRequestDto.setTypeFlag("3");
        nearStoreRequestDto.setPlaceOrderFlag("1");
        nearStoreRequestDto.setPageNo(request.getPageNo());
        nearStoreRequestDto.setPageSize(request.getPageSize());
        if (StringUtils.isBlank(request.getDistance())) {
            nearStoreRequestDto.setDistance("100");
        }
        return nearStoreRequestDto;
    }

    public NearStoreResponseVo convertToNearStoreResponseVo(StoreResponseDto dto) {
        NearStoreResponseVo response = new NearStoreResponseVo();
        response.setRemark(dto.getRemark());
        response.setPhone(dto.getPhone());
        response.setLatitude(dto.getLatitude());
        response.setLongitude(dto.getLongitude());
        response.setAddress(dto.getAddress());
        response.setStoreName(dto.getStoreName());
        response.setBriefName(dto.getBriefName());
        response.setBusinessHoursDay(dto.getBusinessHoursDay());
        response.setDeliveryHoursDay(dto.getDeliveryHoursDay());
        response.setShopId(dto.getStoreCode());
        response.setDistance(dto.getDistance());
        response.setCity(dto.getCity());
        return response;
    }

    public StoreInfoResponseVo convertToStoreInfoResponse(StoreResponseDto dto) {
        StoreInfoResponseVo response = new StoreInfoResponseVo();
        response.setRemark(dto.getRemark());
        response.setPhone(dto.getPhone());
        response.setLatitude(dto.getLatitude());
        response.setLongitude(dto.getLongitude());
        response.setAddress(dto.getAddress());
        response.setStoreName(dto.getStoreName());
        response.setBriefName(dto.getBriefName());
        response.setHasTakeaway(dto.getDelivery() != null && dto.getDelivery() == 1);
        response.setBusinessHoursDay(dto.getBusinessHoursDay());
        response.setDeliveryHoursDay(dto.getDeliveryHoursDay());
        response.setDeliveryAmount(Double.valueOf(dto.getDeliveryPrice()* 100).longValue());
        response.setDeliveryLimitAmount(Double.valueOf(dto.getFreeDeliveryPrice()* 100).longValue());
        response.setShopId(dto.getStoreCode());
        return response;
    }

    public StoreImagesRequestDto convert2StoreImagesRequestDto(String partnerId, String storeId, Integer typeFlag) {
        StoreImagesRequestDto storeImagesRequestDto = new StoreImagesRequestDto();
        storeImagesRequestDto.setPartnerId(partnerId);
        storeImagesRequestDto.setBusinessId(storeId);
        storeImagesRequestDto.setTypeFlag(typeFlag);
        return storeImagesRequestDto;
    }

    public GetBannerPictureListDto convert2BannerListDto(NearStoreRequest request, String wxAppid) {
        GetBannerPictureListDto bannerPictureListDto = new GetBannerPictureListDto();
        bannerPictureListDto.setPartnerId(request.getPartnerId());
        bannerPictureListDto.setWxAppId(wxAppid);
        return bannerPictureListDto;
    }
}
