package cn.freemud.fuyou.controller.request;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;


@Getter
@Setter
public class PayQueryRequest {


        /**
         * 三方订单号
         */
        @NotEmpty(message = "thirdOrderCode 不能为空")
        private String thirdOrderCode;

        /**
         * 下单渠道
         * * 1:自营微信小程序 2:SAAS,i应用 3:自营支付宝小程序 4:自营H5 5:自营安卓APP 6:自营苹果APP 7:自营PC-WEB 8:饿了么 9:饿百 10:京东 11:美团外卖 12:自营APP 13:i应用会员 14:i应用订货 15:POS
         */
        @NotNull(message = "orderClient 不能为空")
        private String orderClient;
        /***
         * posid
         */
        @NotEmpty(message = "posCode不能为空")
        private String posCode;

        @NotEmpty(message = "商户id不能为空")
        //商户号
        private String partnerId;

        @NotEmpty(message = "门店id不能为空")
        private String storeId;

        /**
         * 支付渠道
         * 1. 微信，2.支付宝，3.现金 4.svc，5.积分,6优惠券
         */
        private Integer payChannel;

        /**
         * 支付金额
         */
        private Long payAmount;


}
