package cn.freemud.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: RefundReasonEnum
 * @Package cn.freemud.enums
 * @Description:
 * @author: ping.wu
 * @date: 2019/7/10 14:05
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum RefundReasonEnum {

    Other(1, "其他"),
    Wrong_order(2, "下错单"),
    Goods_not_match_expectations(3, "商品与预期不符"),
    Delivery_Time_too_long(4, "配送时间过长"),
    Misdelivery_Leakage_of_Goods(5, "商品送错送漏"),
    Riders_confirm_service_ahead_of_schedule(6, "骑手提前点确认送达"),

    SPELL_GROUP_FAIL_TIME_OUT(10, "拼团超时取消"),
    SPELL_GROUP_FAIL_SPONSOR_CANCEL(11, "团长取消"),

    ;


    private Integer code;
    private String desc;

    RefundReasonEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static final String SPELL_GROUP_FAIL_API_DOC = "微商城拼团失败原因 1:其他 10:拼团超时取消 11:团长取消";


    private static class EnumCacheHolder {
        private static final Map<Integer, RefundReasonEnum> CACHE;
        private static final Map<Integer, RefundReasonEnum> SPELL_GROUP_FAIL_CACHE;

        static {
            CACHE = Arrays.stream(RefundReasonEnum.values()).collect(Collectors.toMap(RefundReasonEnum::getCode, v -> v));
            SPELL_GROUP_FAIL_CACHE = Stream.of(Other,SPELL_GROUP_FAIL_TIME_OUT,SPELL_GROUP_FAIL_SPONSOR_CANCEL).collect(Collectors.toMap(RefundReasonEnum::getCode, v -> v));
        }
    }

    public static RefundReasonEnum getByIndex(Integer index) {
        return EnumCacheHolder.CACHE.get(index);
    }

    public static RefundReasonEnum getSpellGroupReasonByIndex(Integer index) {
        return EnumCacheHolder.SPELL_GROUP_FAIL_CACHE.get(index);
    }
}
