/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCart
 * @Package cn.freemud.controller
 * @Description:
 * @author: ping.wu
 * @date: 2020/09/29
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.controller;

import cn.freemud.annotations.LogIgnore;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ResponseResult;
import cn.freemud.service.impl.ShoppingCartCollageServiceImpl;
import cn.freemud.utils.ResponseUtil;
import com.freemud.application.sdk.api.base.SDKCommonBaseContextWare;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/shoppingCart/collage", consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "购物车 controller", tags = {"拼单购物车管理接口"})
public class ShoppingCartCollageController {

    /**
     * 向拼单购物车中添加商品
     */
    @PostMapping(value = "/addGoods")
    @LogIgnore(logMessage = "addGoods")
    public BaseResponse addGoods(@Validated @LogParams @RequestBody AddShoppingCartGoodsRequestVo request) {
        return SDKCommonBaseContextWare.getBean(ShoppingCartCollageServiceImpl.class).addGoods(request);
    }

    /**
     * 修改拼单购物车中商品数量
     */
    @LogIgnore(logMessage = "updateGoodsQty")
    @PostMapping(value = "/updateGoodsQty")
    public BaseResponse updateGoodsQty(@Validated @LogParams @RequestBody UpdateShoppingCartGoodsQtyRequestVo request) {
        return SDKCommonBaseContextWare.getBean(ShoppingCartCollageServiceImpl.class).updateGoodsQty(request);
    }

    /**
     * 查询购物车信息
     */
    @LogIgnore(logMessage = "listCartGoods")
    @PostMapping(value = "/listCartGoods")
    public BaseResponse listCartGoods(@Validated @LogParams @RequestBody ShoppingCartInfoRequestVo request) {
        return SDKCommonBaseContextWare.getBean(ShoppingCartCollageServiceImpl.class).getGoodsList(request);
    }

    /**
     * 清空自己的购物车
     */
    @LogIgnore(logMessage = "clearPartCartGoods")
    @PostMapping(value = "/clearPartCartGoods")
    public BaseResponse clearPartCartGoods(@Validated @LogParams @RequestBody ShoppingCartCollageClearRequestVo request) {
        return SDKCommonBaseContextWare.getBean(ShoppingCartCollageServiceImpl.class).clearPartCarGoods(request);
    }

    /**
     * 清空购物车
     */
    @LogIgnore(logMessage = "clearCartGoods")
    @PostMapping(value = "/clearCartGoods")
    public BaseResponse clearCartGoods(@Validated @LogParams @RequestBody ShoppingCartClearRequestVo request) {
        return SDKCommonBaseContextWare.getBean(ShoppingCartCollageServiceImpl.class).clear(request);
    }

    /**
     * 获取购物车均摊详情，点 "去支付" 时调用
     *
     * @param getShoppingCartGoodsApportionRequestVo
     * @return
     */
    @LogIgnore(logMessage = "getShoppingCartGoodsApportion")
    @PostMapping(value = "/getShoppingCartGoodsApportion")
    public BaseResponse getShoppingCartGoodsApportion(@Validated @LogParams @RequestBody GetShoppingCartGoodsApportionRequestVo getShoppingCartGoodsApportionRequestVo) {
        if (getShoppingCartGoodsApportionRequestVo == null || getShoppingCartGoodsApportionRequestVo.getShoppingCartInfoRequestVo() == null) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }
        ShoppingCartInfoRequestVo shoppingCartInfoRequestVo = getShoppingCartGoodsApportionRequestVo.getShoppingCartInfoRequestVo();

        return SDKCommonBaseContextWare.getBean(ShoppingCartCollageServiceImpl.class).getShoppingCartGoods(shoppingCartInfoRequestVo, getShoppingCartGoodsApportionRequestVo.getPremiumExchangeActivity());
    }

    /**
     * 查询购物车版本号
     */
    @ApiAnnotation(logMessage = "queryCarVer")
    @PostMapping(value = "/queryCarVer")
    public BaseResponse queryCarVer(@Validated @LogParams @RequestBody CollageShoppingCartVerRequestVo request) {
        return SDKCommonBaseContextWare.getBean(ShoppingCartCollageServiceImpl.class).queryCarVer(request);
    }

    /**
     * 查询购车信息无配送费
     * SVC卡支付check，check购物车金额加配送费小于储值卡金额
     */
    @LogIgnore(logMessage = "listCartGoodsCheck")
    @PostMapping(value = "/listCartGoodsCheck")
    public BaseResponse listCartGoodsCheck(@Validated @LogParams @RequestBody ShoppingCartInfoRequestVo request) {
        return SDKCommonBaseContextWare.getBean(ShoppingCartCollageServiceImpl.class).getGoodsListCheck(request);
    }
}
