package cn.freemud.management.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.activity.GroupWorkRefundResponse;
import cn.freemud.management.entities.dto.response.order.OrderManagerResponse;
import cn.freemud.management.entities.dto.response.pay.PayRefundResponse;
import cn.freemud.management.enums.OperateType;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.intercept.OrderServiceException;
import cn.freemud.management.service.OrderBaseService;
import cn.freemud.management.service.OrderManagerService;
import cn.freemud.management.service.handle.*;
import cn.freemud.management.util.ResponseUtil;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.constant.ResponseConstant;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.enums.AfterSalesStatus;
import com.freemud.application.sdk.api.ordercenter.enums.BizTypeEnum;
import com.freemud.application.sdk.api.ordercenter.enums.MarketTypeEnum;
import com.freemud.application.sdk.api.ordercenter.enums.RefundModeEnum;
import com.freemud.application.sdk.api.ordercenter.request.AfterOrderExtInfoDto;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: rrr
 * @Package cn.freemud.management.service.impl
 * @Description: 新版商城订单履单操作
 * @author:
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class NewMallOrderMangerServiceImpl implements OrderManagerService {
    @Autowired
    private MallOrderHandle mallOrderHandle;
    @Autowired
    private PaymentHandle paymentHandle;
    @Autowired
    private StockHandle stockHandle;
    @Autowired
    private ActivityHandle activityHandle;

    /**
     * 同意退款
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderAgreeRefund(OrderManagerRequest request, OrderBeanV1 orderBean) {

        Byte refundMode = RefundModeEnum.UN_REFUND_GOODS.getIndex();
        if(null != orderBean.getAfterSalesOrderResp() && StringUtils.isNotEmpty(orderBean.getAfterSalesOrderResp().getExtInfo())){
            AfterOrderExtInfoDto afterOrderExtInfoDto = JSONObject.parseObject(orderBean.getAfterSalesOrderResp().getExtInfo(),AfterOrderExtInfoDto.class);
            if(null !=afterOrderExtInfoDto) {
                refundMode = afterOrderExtInfoDto.getRefundMode();
            }
        }
        if (Objects.equals(RefundModeEnum.REFUND_ALL.getIndex(), refundMode) && Objects.nonNull(orderBean.getAfterSalesOrderResp()) && Objects.equals(AfterSalesStatus.PENDING.getIndex(), orderBean.getAfterSalesOrderResp().getAfterSalesStatus())) {
            // 修改售后单状态为退货中
            mallOrderHandle.mallOrderAgreeApply(request, orderBean);
        } else {
            //支付退款
            PayRefundResponse refundResponse = new PayRefundResponse();
            try {
                refundResponse = paymentHandle.refund(request, orderBean);
            } catch (OrderServiceException orderEx) {
                return ResponseUtil.error(orderEx.getResult());
            }
            //订单同意退款
            mallOrderHandle.refundAgree(request, refundResponse, orderBean);
            //冲正库存
            stockHandle.revert(request, orderBean);
        }
        return ResponseUtil.success();
    }

    /**
     * 拒绝退款
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderRejectRefund(OrderManagerRequest request, OrderBeanV1 orderBean) {
        //拒绝退款
        mallOrderHandle.mallRefundReject(request,orderBean);
        return ResponseUtil.success();
    }

    /**
     * 拒单
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderReject(OrderManagerRequest request, OrderBeanV1 orderBean) {
        return ResponseUtil.error("501","暂无");
    }

}
