package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.AddUserOrderEvaluationNewRequestVo;
import cn.freemud.entities.vo.GetEvaluationDetailByOrderIdRequestVo;
import cn.freemud.entities.vo.GetEvaluationStatusNewRequestVo;
import cn.freemud.service.EvaluationService;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * All rights Reserved, Designed By www.freemud.com
 *
 * @version V1.0
 * @Title:
 * @Package: cn.freemud.controller
 * @Descripttion:
 * @author: shuhu.hou
 * @date: 2019/8/12
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目.
 */
@RequestMapping("/order")
@RestController
@Validated
public class EvaluationController {

    @Autowired
    private EvaluationService evaluationService;

    /**
     * 用户评价（新接口）
     */
    @ApiAnnotation(logMessage = "userOrderEvaluationNew")
    @PostMapping("/userOrderEvaluationNew")
    public BaseResponse userOrderEvaluation(@LogParams @RequestBody AddUserOrderEvaluationNewRequestVo request) {
        return evaluationService.userOrderEvaluationNew(request);
    }

    /**
     * 判断订单是否已评价（新接口）
     */
    @ApiAnnotation(logMessage = "getOrderEvaluationStatusNew")
    @PostMapping("/getOrderEvaluationStatusNew")
    public BaseResponse getOrderEvaluationStatus(@LogParams @RequestBody GetEvaluationStatusNewRequestVo request) {
        return evaluationService.getEvaluationStatusNew(request);
    }
    /**
     * 查看订单评价详情
     */
    @ApiAnnotation(logMessage = "getEvaluationDetailsByOrderId")
    @PostMapping("/getEvaluationDetailsByOrderId")
    public BaseResponse getOrderEvaluationDetails(@LogParams @RequestBody GetEvaluationDetailByOrderIdRequestVo request) {
        return evaluationService.getEvaluationByOrderId(request);
    }
}
