package cn.freemud.entities.dto.promotion;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Data
public class ActivitySendGoodsVO {

    @ApiModelProperty(value="活动号", name="activityCode", example="ZSS8373737373737")
    private String activityCode;

    @ApiModelProperty(value="商品id", name="goodsId", example="187349235")
    @NotNull(message = "不可为空")
    private String goodsId;

    @ApiModelProperty(value="商品CODE", name="goodsCode")
    private String goodsCode;

    @ApiModelProperty(value="商品UPC编码", name="goodsUpc")
    private String goodsUpc;

    @ApiModelProperty(value="品类", name="category", example="yinliao")
    private String category;

    @ApiModelProperty(value="商品名", name="goodsName", example="冰糖雪梨")
    private String goodsName;

    @ApiModelProperty(value="原价", name="originalPrice", example="1800")
    private Integer originalPrice;

    @ApiModelProperty(value="现价", name="nowPrice", example="500")
    private Integer nowPrice;

    @ApiModelProperty(value="限制数量", name="quantityLimit", example="10")
    private Integer quantityLimit;

    @Min(0)
    @ApiModelProperty(value="赠送数量", name="sendNumber", example="2")
    private Integer sendNumber;

    @ApiModelProperty(value="赠品类型 0或null为计件赠品  1为称重赠品", name="sendGoodsType", example="0")
    private Integer sendGoodsType;


    @ApiModelProperty(value="赠品重量 g为单位", name="sendGoodsWeight", example="1000")
    private Integer sendGoodsWeight;

    @ApiModelProperty(value = "排序", name = "serialNumber", example = "99")
    private Integer serialNumber;

    @ApiModelProperty(value = "重量,最多四位小数，单位kg")
    private Double weight;

    @ApiModelProperty(value = "单位")
    private String unit;
}