/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartNewServiceTest
 * @Package cn.freemud.service
 * @Description:
 * @author: song.cai
 * @date: 2019/1/23 16:56
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ResponseResult;
import cn.freemud.service.impl.ShoppingCartMealServiceImpl;
import cn.freemud.service.impl.mcoffee.ShoppingCartMCoffeeServiceImpl;
import cn.freemud.service.impl.mcoffee.calculation.CalculationServiceImpl;
import cn.freemud.service.impl.mcoffee.calculation.CouponDiscountCalculation;
import cn.freemud.service.impl.mcoffee.entity.MCoffeeAddGoodsRequestVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.freemud.sdk.api.assortment.shoppingcart.constant.MealClearOperationEnum;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class ShoppingCartMCoffeeServiceTest {

    @Autowired
    private ShoppingCartMCoffeeServiceImpl shoppingCartMCoffeeService;

    @Autowired
    private CouponDiscountCalculation couponDiscountCalculation;

    @Test
    public void f1() {
        shoppingCartMCoffeeService.addGoods(JSON.parseObject("{\"appId\":\"wx6816a0b007741702\",\"channelType\":\"saas\",\"couponCode\":\"601153527093109\",\"couponType\":0,\"extra\":[],\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"1628\",\"productComboList\":[{\"extra\":[],\"productMaterialList\":[],\"skuId\":\"204903200109635372\"}],\"productGroupList\":[],\"qty\":1,\"receiveId\":\"\",\"sessionId\":\"408cc5c5ce3967f849859d1cd11000ab1cf34729\",\"shopId\":\"99998\",\"skuId\":\"204906489299783199\",\"spuId\":\"204906489299783199\"}", MCoffeeAddGoodsRequestVo.class));
    }

    @Test
    public void f2() {
        shoppingCartMCoffeeService.updateGoodsQty(JSON.parseObject("{\"appId\":\"wx6816a0b007741702\",\"cartGoodsUid\":\"c9fd8e50-8dc9-48e2-a36e-bd6313ef81e9\",\"channelType\":\"saas\",\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"1206\",\"qty\":2,\"receiveId\":\"\",\"sessionId\":\"f3e238f5b30270ce4353695fe619fd6ddf9ce9ad\",\"shopId\":\"1450026\"}", UpdateShoppingCartGoodsQtyRequestVo.class));
    }

    @Test
    public void f3() {
        shoppingCartMCoffeeService.getGoodsList(JSON.parseObject("{\"appId\":\"wx6816a0b007741702\",\"buyType\":0,\"channelType\":\"saas\",\"couponCode\":\"\",\"isUseMonthCard\":1,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"1206\",\"receiveId\":\"\",\"sessionId\":\"b336cc00111c142d437236bfa69a688dfbc112c0\",\"shopId\":\"1450026\"}", ShoppingCartInfoRequestVo.class));
    }

    @Test
    public void f4() {
        couponDiscountCalculation.updateShoppingCartGoodsDiscount(
                JSON.parseObject("{\"apportionGoods\":[],\"couponDiscounts\":[],\"discounts\":[{\"activityCode\":\"227530982528469\",\"activityName\":\"买三赠一券_测试环境测试\",\"discount\":8400,\"extendType\":7,\"type\":35}],\"distributionFee\":0,\"goods\":[{\"actualGoodsNumber\":3,\"artNo\":\"100057810029630759\",\"cartGoodType\":0,\"cartGoodsUid\":\"a8adfdc8-6bd4-4add-8fd3-7bcb60ec25fe\",\"discountAmount\":6300,\"discounts\":[{\"activityCode\":\"227530982528469\",\"activityName\":\"买三赠一券_测试环境测试\",\"actualGoodsNumber\":3,\"discount\":6300,\"goodsId\":\"207742812203125004\",\"type\":35}],\"goodsId\":\"207742812203125004\",\"goodsQuantity\":3,\"nowPrice\":2100,\"originalPrice\":2100,\"realAmount\":0,\"smallMaterial\":[]},{\"actualGoodsNumber\":1,\"artNo\":\"100057810029630759\",\"cartGoodType\":0,\"cartGoodsUid\":\"833b4365-7528-45be-b8ff-2ac4df07ed65\",\"discountAmount\":2100,\"discounts\":[{\"activityCode\":\"227530982528469\",\"activityName\":\"买三赠一券_测试环境测试\",\"actualGoodsNumber\":1,\"discount\":2100,\"goodsId\":\"207742812203125004\",\"type\":35}],\"goodsId\":\"207742812203125004\",\"goodsQuantity\":1,\"nowPrice\":2100,\"originalPrice\":2100,\"realAmount\":0,\"smallMaterial\":[]},{\"cartGoodType\":0,\"cartGoodsUid\":\"3cd19696-094f-4cc8-b049-e9b5ceabc1b3\",\"discountAmount\":0,\"discounts\":[],\"goodsId\":\"207742812203125004\",\"goodsQuantity\":1,\"nowPrice\":2100,\"originalPrice\":2100,\"realAmount\":2100,\"smallMaterial\":[]},{\"cartGoodType\":0,\"cartGoodsUid\":\"78fb0357-99a5-4931-b35c-48fcc9e577f3\",\"discountAmount\":0,\"discounts\":[],\"goodsId\":\"210821303631043841\",\"goodsQuantity\":1,\"nowPrice\":2500,\"originalPrice\":2500,\"realAmount\":2500,\"smallMaterial\":[]},{\"cartGoodType\":0,\"cartGoodsUid\":\"84c0005d-96e7-4103-a1dd-32fd790c28d0\",\"discountAmount\":0,\"discounts\":[],\"goodsId\":\"210886471963527432\",\"goodsQuantity\":1,\"nowPrice\":990,\"originalPrice\":990,\"realAmount\":990,\"smallMaterial\":[]},{\"cartGoodType\":0,\"cartGoodsUid\":\"edd1ecaa-4aad-43c1-82e0-fb03540ddea1\",\"discountAmount\":0,\"discounts\":[],\"goodsId\":\"9998\",\"goodsQuantity\":1,\"nowPrice\":0,\"originalPrice\":0,\"realAmount\":0,\"smallMaterial\":[]}],\"originalTotalAmount\":13990,\"stocks\":[],\"totalAmount\":5590,\"totalDiscountAmount\":8400}", ActivityCalculationDiscountResponseDto.CalculationDiscountResult.class),
                JSON.parseArray("[{\"amount\":2100,\"cartGoodsUid\":\"a8adfdc8-6bd4-4add-8fd3-7bcb60ec25fe\",\"categoryName\":\"\",\"classificationId\":\"\",\"classificationName\":\"\",\"couponCode\":\"227530982528469\",\"couponName\":\"买三赠一券_测试环境测试\",\"createTimeMili\":1624243026338,\"customerCode\":\"510479\",\"finalPrice\":2100,\"goodsId\":\"207742812203125004\",\"goodsType\":5,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":1,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isTableware\":false,\"memberDiscount\":100,\"name\":\"冰燕麦拿铁中杯\",\"originalAmount\":8400,\"originalPrice\":2100,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1620898286570.png\",\"productComboList\":[],\"productGroupList\":[],\"qty\":3,\"riseSell\":1,\"skuId\":\"207742812203125004\",\"skuName\":\"冰燕麦拿铁中杯\",\"spuId\":\"207742812203125004\",\"spuName\":\"冰燕麦拿铁中杯\",\"stockLimit\":false,\"subName\":\"\",\"tax\":0.01,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"amount\":0,\"cartGoodsUid\":\"833b4365-7528-45be-b8ff-2ac4df07ed65\",\"categoryName\":\"\",\"classificationId\":\"\",\"classificationName\":\"\",\"couponCode\":\"227530982528469\",\"couponName\":\"买三赠一券_测试环境测试\",\"createTimeMili\":1624243026338,\"customerCode\":\"510479\",\"finalPrice\":2100,\"goodsId\":\"207742812203125004\",\"goodsType\":5,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":1,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isTableware\":false,\"memberDiscount\":100,\"name\":\"冰燕麦拿铁中杯\",\"originalAmount\":2100,\"originalPrice\":2100,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1620898286570.png\",\"productComboList\":[],\"productGroupList\":[],\"qty\":1,\"riseSell\":1,\"skuId\":\"207742812203125004\",\"skuName\":\"冰燕麦拿铁中杯\",\"spuId\":\"207742812203125004\",\"spuName\":\"冰燕麦拿铁中杯\",\"stockLimit\":false,\"subName\":\"\",\"tax\":0.01,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"amount\":8400,\"cartGoodsUid\":\"3cd19696-094f-4cc8-b049-e9b5ceabc1b3\",\"categoryName\":\"\",\"classificationId\":\"\",\"classificationName\":\"\",\"couponCode\":\"227530982528469\",\"couponName\":\"买三赠一券_测试环境测试\",\"createTimeMili\":1624243026338,\"customerCode\":\"510479\",\"finalPrice\":2100,\"goodsId\":\"207742812203125004\",\"goodsType\":5,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":1,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isTableware\":false,\"memberDiscount\":100,\"name\":\"冰燕麦拿铁中杯\",\"originalAmount\":8400,\"originalPrice\":2100,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1620898286570.png\",\"productComboList\":[],\"productGroupList\":[],\"qty\":1,\"riseSell\":1,\"skuId\":\"207742812203125004\",\"skuName\":\"冰燕麦拿铁中杯\",\"spuId\":\"207742812203125004\",\"spuName\":\"冰燕麦拿铁中杯\",\"stockLimit\":false,\"subName\":\"\",\"tax\":0.01,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"amount\":990,\"b3S1CouponGoodsInfo\":{\"cardCode\":\"227530982528469\",\"cardNo\":\"SCPQ04D51730C44FDDC039CC8F1510B55DC3\",\"isUseB3S1Coupon\":1,\"useTimes\":4},\"cartGoodsUid\":\"84c0005d-96e7-4103-a1dd-32fd790c28d0\",\"classificationId\":\"\",\"classificationName\":\"\",\"createTimeMili\":1624243042727,\"customerCode\":\"509835\",\"finalPrice\":990,\"goodsId\":\"210886471963527432\",\"goodsType\":9,\"isB3S1Coupon\":1,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isTableware\":false,\"memberDiscount\":100,\"name\":\"买三赠一\",\"originalAmount\":990,\"originalPrice\":990,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1623897302228.png\",\"productComboList\":[],\"productGroupList\":[],\"qty\":1,\"riseSell\":1,\"skuId\":\"210886471963527432\",\"skuName\":\"买三赠一\",\"spuId\":\"210886471963527432\",\"spuName\":\"买三赠一\",\"stockLimit\":false,\"subName\":\"\",\"tax\":0.01,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"amount\":0,\"b3S1CouponGoodsInfo\":{\"cardCodeSet\":[\"227530982528469\"],\"isUseB3S1Coupon\":1},\"cartGoodsUid\":\"edd1ecaa-4aad-43c1-82e0-fb03540ddea1\",\"createTimeMili\":1624243042899,\"goodsId\":\"9998\",\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isTableware\":false,\"originalAmount\":0,\"packPrice\":0,\"qty\":1,\"skuId\":\"9998\",\"spuId\":\"9998\",\"stockLimit\":false,\"weightType\":false},{\"amount\":2500,\"cartGoodsUid\":\"78fb0357-99a5-4931-b35c-48fcc9e577f3\",\"classificationId\":\"\",\"classificationName\":\"\",\"createTimeMili\":1624243042916,\"customerCode\":\"510480\",\"finalPrice\":2500,\"goodsId\":\"210821303631043841\",\"goodsType\":5,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isTableware\":false,\"memberDiscount\":100,\"name\":\"大杯燕麦拿铁\",\"originalAmount\":2500,\"originalPrice\":2500,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1623810240405.png\",\"productComboList\":[],\"productGroupList\":[],\"qty\":1,\"riseSell\":1,\"skuId\":\"210821303631043841\",\"skuName\":\"大杯燕麦拿铁\",\"spuId\":\"210821303631043841\",\"spuName\":\"大杯燕麦拿铁\",\"stockLimit\":false,\"subName\":\"\",\"tax\":0.01,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false}]", CartGoods.class),
                new ShoppingCartGoodsResponseVo());
    }

}
