/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderType
 * @Package cn.freemud.enums
 * @Description: 订单类型
 * @author: liming.guo
 * @date: 2018/5/21 14:43
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.enums;

import com.google.common.collect.Lists;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

public enum OrderType {

    TAKE_OUT(1, "外卖"),
    PRE_ORDER(2, "预订单"),
    MALL(3, "商城"),
    COLLECT_GOODS(4, "打包带走"),
    EAT_IN(5, "店内就餐"),
    SPELL_GROUP(6, "拼团")
    ;

    private Integer code;
    private String desc;

    OrderType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static List<Integer> getAllCodes() {
        List<Integer> list = Lists.newArrayList();
        for (OrderType orderType : values()) {
            list.add(orderType.getCode());
        }
        return list;
    }


    public static OrderType getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (OrderType orderType : values()) {
            if (orderType.getCode().equals(code)) {
                return orderType;
            }
        }
        return null;
    }

    public static List getByCode(List<Integer> list) {
        List returnList = new ArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return returnList;
        }
        for (OrderType orderType : values()) {
            for (Integer code: list) {
                if (orderType.getCode().equals(code)) {
                    returnList.add(code);
                }
            }
        }
        return returnList;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
