package cn.freemud.entities.db;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.5.1
 * @Title: OpenPlatformIappWxappConfigDelivery
 * @Package cn.freemud.entities.db
 * @Description: 简单描述下这个类是做什么用的
 * @author: hang.chai
 * @date: 2018/12/17 16:12
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
@Table(name = "open_platform_iapp_wxapp_config_delivery")
public class OpenPlatformIappWxappConfigDelivery {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 自定义小程序appid
     */
    private String appid;

    /**
     * 微信小程序appid
     */
    @Column(name = "wx_appid")
    private String wxAppid;

    /**
     * 商户品牌id
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 定时推单类型
     */
    @Column(name = "push_order_type")
    private Integer pushOrderType;

    /**
     * 定时推单时间
     */
    @Column(name = "push_order_time")
    private Integer pushOrderTime;

    /**
     * 渠道id
     */
    @Column(name = "channel_id")
    private String channelId;

    /**
     * 渠道名称
     */
    @Column(name = "channel_name")
    private String channelName;

    /**
     * 渠道短码
     */
    @Column(name = "short_code")
    private String shortCode;

    /**
     * 商户配送渠道账号业务主键
     */
    @Column(name = "channel_account_id")
    private String channelAccountId;

    /**
     * 商户账号
     */
    @Column(name = "app_key")
    private String appKey;

    /**
     * 商户凭证
     */
    @Column(name = "app_secret")
    private String appSecret;

    /**
     * 配送方案ID
     */
    @Column(name = "delivery_plan_id")
    private String deliveryPlanId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取自定义小程序appid
     *
     * @return appid - 自定义小程序appid
     */
    public String getAppid() {
        return appid;
    }

    /**
     * 设置自定义小程序appid
     *
     * @param appid 自定义小程序appid
     */
    public void setAppid(String appid) {
        this.appid = appid;
    }

    /**
     * 获取商户品牌id
     *
     * @return partner_id - 商户品牌id
     */
    public String getPartnerId() {
        return partnerId;
    }

    /**
     * 设置商户品牌id
     *
     * @param partnerId 商户品牌id
     */
    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    /**
     * 获取定时推单类型
     *
     * @return push_order_type - 定时推单类型
     */
    public Integer getPushOrderType() {
        return pushOrderType;
    }

    /**
     * 设置定时推单类型
     *
     * @param pushOrderType 定时推单类型
     */
    public void setPushOrderType(Integer pushOrderType) {
        this.pushOrderType = pushOrderType;
    }

    /**
     * 获取定时推单时间
     *
     * @return push_order_time - 定时推单时间
     */
    public Integer getPushOrderTime() {
        return pushOrderTime;
    }

    /**
     * 设置定时推单时间
     *
     * @param pushOrderTime 定时推单时间
     */
    public void setPushOrderTime(Integer pushOrderTime) {
        this.pushOrderTime = pushOrderTime;
    }

    /**
     * 获取渠道id
     *
     * @return channel_id - 渠道id
     */
    public String getChannelId() {
        return channelId;
    }

    /**
     * 设置渠道id
     *
     * @param channelId 渠道id
     */
    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    /**
     * 获取渠道名称
     *
     * @return channel_name - 渠道名称
     */
    public String getChannelName() {
        return channelName;
    }

    /**
     * 设置渠道名称
     *
     * @param channelName 渠道名称
     */
    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    /**
     * 获取渠道短码
     *
     * @return short_code - 渠道短码
     */
    public String getShortCode() {
        return shortCode;
    }

    /**
     * 设置渠道短码
     *
     * @param shortCode 渠道短码
     */
    public void setShortCode(String shortCode) {
        this.shortCode = shortCode;
    }

    /**
     * 获取商户配送渠道账号业务主键
     *
     * @return channel_account_id - 商户配送渠道账号业务主键
     */
    public String getChannelAccountId() {
        return channelAccountId;
    }

    /**
     * 设置商户配送渠道账号业务主键
     *
     * @param channelAccountId 商户配送渠道账号业务主键
     */
    public void setChannelAccountId(String channelAccountId) {
        this.channelAccountId = channelAccountId;
    }

    /**
     * 获取商户账号
     *
     * @return app_key - 商户账号
     */
    public String getAppKey() {
        return appKey;
    }

    /**
     * 设置商户账号
     *
     * @param appKey 商户账号
     */
    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    /**
     * 获取商户凭证
     *
     * @return app_secret - 商户凭证
     */
    public String getAppSecret() {
        return appSecret;
    }

    /**
     * 设置商户凭证
     *
     * @param appSecret 商户凭证
     */
    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    /**
     * 获取配送方案ID
     *
     * @return delivery_plan_id - 配送方案ID
     */
    public String getDeliveryPlanId() {
        return deliveryPlanId;
    }

    /**
     * 设置配送方案ID
     *
     * @param deliveryPlanId 配送方案ID
     */
    public void setDeliveryPlanId(String deliveryPlanId) {
        this.deliveryPlanId = deliveryPlanId;
    }

    /**
     * 获取备注
     *
     * @return remark - 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 获取创建时间
     *
     * @return gmt_created - 创建时间
     */
    public Date getGmtCreated() {
        return gmtCreated;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreated 创建时间
     */
    public void setGmtCreated(Date gmtCreated) {
        this.gmtCreated = gmtCreated;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}