package cn.freemud.service.impl

import cn.freemud.adapter.ShoppingCartConvertAdapter
import cn.freemud.adapter.StoreItemAdapter
import cn.freemud.entities.dto.GetCouponDetailResponseDto
import cn.freemud.entities.dto.ProductBaseResponse
import cn.freemud.entities.dto.ProductInfosDto
import cn.freemud.entities.dto.ProductListDto
import cn.freemud.entities.dto.product.CheckCartRequest
import cn.freemud.entities.dto.product.ValiadShopProductResponse
import cn.freemud.entities.vo.AddShoppingCartGoodsRequestVo
import cn.freemud.entities.vo.CartGoods
import cn.freemud.service.CouponService
import cn.freemud.service.ItemService
import cn.freemud.service.thirdparty.CouponOnlineClient
import cn.freemud.service.thirdparty.ProductClient
import com.alibaba.fastjson.JSON
import com.alibaba.fastjson.TypeReference
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager
import com.freemud.application.sdk.api.base.SDKCommonBaseContextWare
import org.junit.runner.RunWith
import org.mockito.Mockito
import org.powermock.api.mockito.PowerMockito
import org.powermock.core.classloader.annotations.PrepareForTest
import org.powermock.modules.junit4.PowerMockRunner
import org.powermock.modules.junit4.PowerMockRunnerDelegate
import org.spockframework.runtime.Sputnik
import spock.lang.Specification

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/3/16 15:16
 * @description : 
 */
@RunWith(PowerMockRunner.class)
@PowerMockRunnerDelegate(Sputnik.class)
@PrepareForTest([ShoppingCartConvertAdapter.class,
        SDKCommonBaseContextWare.class])
class ShoppingCartNewServiceImpt2PowerMockTest extends Specification {
    def shoppingCartNewServiceImpl = new ShoppingCartNewServiceImpl()
    def customerInfoManager = PowerMockito.mock(AssortmentCustomerInfoManager)
    def assortmentSdkService = new AssortmentSdkService()
    def couponServiceImpl = new CouponServiceImpl()
    def couponOnlineClient = PowerMockito.mock(CouponOnlineClient)
    def itemService = new ItemServiceImpl()
    def storeItemAdapter = new StoreItemAdapter()
    def storeItemClient = PowerMockito.mock(ProductClient)

    void setup() {
        shoppingCartNewServiceImpl.customerInfoManager = customerInfoManager
        shoppingCartNewServiceImpl.assortmentSdkService = assortmentSdkService
        couponServiceImpl.couponOnlineClient = couponOnlineClient
        couponServiceImpl.itemService = itemService
        couponServiceImpl.storeItemClient = storeItemClient
        itemService.storeItemAdapter = storeItemAdapter
        itemService.storeItemClient = storeItemClient
        assortmentSdkService.storeItemClient = storeItemClient

        // mock静态类
        PowerMockito.mockStatic(SDKCommonBaseContextWare.class)

    }

    def "测试 /addGoods"() {
        given: "request 请求参数"
        def addShoppingCartGoodsRequestVo = JSON.parseObject("{\"channelType\":\"saas\",\"channel\":1,\"partnerId\":\"2690\",\"appId\":\"wxa1f272347828dae8\",\"version\":\"2.0.68.7\",\"sessionId\":\"1410a547ea1bf178f17032a9e12ac6606db8cc6f\",\"orderType\":1,\"menuType\":\"saas\",\"shopId\":\"QAJIALE001\",\"spuId\":\"215809930343585821\",\"skuId\":\"\",\"qty\":1,\"categoryId\":\"0101\",\"productMaterialList\":[],\"categoryName\":\"单品\",\"productComboList\":[],\"productGroupList\":[],\"receiveId\":\"\",\"bizType\":null}"
                , AddShoppingCartGoodsRequestVo.class)

        and: "模拟第三方响应结果数据"
        def customerInfoVo = JSON.parseObject("{\"accessToken\":\"\",\"alipayUserId\":\"\",\"appId\":\"wx3f7ca0c75b213380\",\"appSecret\":\"\",\"appsecret\":\"\",\"channel\":\"1\",\"customerId\":\"\",\"devBrand\":\"\",\"devModel\":\"\",\"iappId\":\"7\",\"memberId\":\"3614319825989629832\",\"mobile\":\"17327190802\",\"newMember\":false,\"nickName\":\"SWEET SUGA\",\"openId\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"openid\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"partnerId\":\"2581\",\"photoUrl\":\"https://thirdwx.qlogo.cn/mmopen/vi_32/zahIlicTNSM0IA0qjOryv6s0SzIhlwW9EpQKvL63GbPhBwficMAibDohDEibSCQU0I5KohibIpp0yL57TWRcVKrRH2A/132\",\"registerTime\":\"2021-02-26 14:10:26\",\"sessionId\":\"eac53a53f8ae62def7f40cb1e47a1bd9791d95a8\",\"sessionKey\":\"GCyyapzbBSM4yXh9AduGOw==\",\"session_key\":\"GCyyapzbBSM4yXh9AduGOw==\",\"storeId\":\"\",\"tableNumber\":\"\",\"thirdPartyMemberID\":\"\",\"thirdPartyPartnerID\":\"\",\"unionId\":\"o7cEm68JPFhbrzqb0a0BcQE-dDVA\",\"wxAppId\":\"wx3f7ca0c75b213380\",\"wxAppid\":\"wx3f7ca0c75b213380\"}"
                , AssortmentCustomerInfoVo.class)
        def responseDto = JSON.parseObject(""
                , GetCouponDetailResponseDto.class)
        def productInfosDto = JSON.parseObject(""
                , ProductInfosDto.class)
        def productListDto = JSON.parseObject(""
                , ProductListDto.class)
        def valiadProductResponse = JSON.parseObject(""
                , new TypeReference<ProductBaseResponse<ValiadShopProductResponse>>() {})
        def productInfosDto2 = JSON.parseObject(""
                , new TypeReference<ProductInfosDto>() {})

        // 模拟购物车商品
        def goodList = JSON.parseArray("[{\"addCartTime\":1646286585880,\"amount\":800,\"canUseCoupon\":0,\"cartGoodsUid\":\"b8eca7b4-8627-4726-8560-b1d9f74a1c8b\",\"couponCode\":\"88709227085491207040\",\"createTimeMili\":1646286585880,\"extra\":[],\"goodsId\":\"spq88709227085491207040\",\"goodsType\":10,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isUseMonthCard\":0,\"linkedId\":\"\",\"originalAmount\":0,\"originalPrice\":800,\"originalProductType\":1,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1619081297921.jpg\",\"productComboList\":[],\"productGroupList\":[],\"productMaterialList\":[],\"qty\":2,\"skuId\":\"201889966261817090\",\"skuName\":\"鸡米花T\",\"spuId\":\"201889966261817090\",\"stockLimit\":false,\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"addCartTime\":1646286600492,\"amount\":500,\"canUseCoupon\":1,\"cartGoodsUid\":\"87653424-e6ef-45c7-ad84-2ebc777cccc9\",\"categoryName\":\"缤纷小食\",\"classificationForeignName\":\"正价单品\",\"classificationId\":\"0102\",\"classificationName\":\"正价单品\",\"createTimeMili\":1646286600492,\"customerCode\":\"hn80180054\",\"finalPrice\":500,\"foreignName\":\"\",\"goodsId\":\"201889968054882060\",\"goodsType\":5,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isUseMonthCard\":0,\"linkedId\":\"\",\"materialAmount\":0,\"memberDiscount\":100,\"name\":\"元气鸡排T\",\"originalAmount\":500,\"originalMaterialAmount\":0,\"originalPrice\":500,\"originalProductType\":1,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1619082050722.jpg\",\"productComboList\":[],\"productGroupList\":[],\"productMaterialList\":[],\"qty\":1,\"riseSell\":1,\"singleOrder\":0,\"skuForeignName\":\"\",\"skuId\":\"\",\"skuName\":\"元气鸡排T\",\"spuForeignName\":\"\",\"spuId\":\"201889968054882060\",\"spuName\":\"元气鸡排T\",\"stockLimit\":false,\"subForeignName\":\"\",\"subName\":\"\",\"tax\":0.01,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false}]"
                , CartGoods.class)

        and: "模拟第三方调用"
        Mockito.when(customerInfoManager.getCustomerInfoByObject(Mockito.any())).thenReturn(customerInfoVo)
        Mockito.when(couponOnlineClient.getCouponDetails(Mockito.any())).thenReturn(responseDto)
        Mockito.when(storeItemClient.listProductInfos(Mockito.any())).thenReturn(productInfosDto)
        Mockito.when(storeItemClient.getSpuIdsBySkuIds(Mockito.any())).thenReturn(productListDto)
        Mockito.when(storeItemClient.validateShopProduct(Mockito.any())).thenReturn(valiadProductResponse)
        Mockito.when(storeItemClient.listProductInfos(Mockito.any())).thenReturn(productInfosDto2)
        Mockito.when(assortmentSdkService.getShoppingCart(Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(goodList)

        and: "静态方法mock"
        PowerMockito.when(SDKCommonBaseContextWare.getBean(CouponService.class)).thenReturn(couponServiceImpl)

        when: "调用方法逻辑"
        def response = shoppingCartNewServiceImpl.addGoods(addShoppingCartGoodsRequestVo)

        then: "验证 返回结果"
        with(response) {
            code == "100"
            message == "success"
        }
    }

}
