package cn.freemud.service.impl

import cn.freemud.adapter.OrderAdapter
import cn.freemud.entities.bo.CreateOrderBONew
import cn.freemud.entities.dto.blacklist.Result
import cn.freemud.entities.dto.blacklist.resp.MemberBlacklistVO
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto
import cn.freemud.entities.dto.store.StoreMixResponseDto
import cn.freemud.entities.vo.CreateOrderVo
import cn.freemud.handler.MemberBlacklistHandler
import cn.freemud.service.business.impl.OrderBusinessServiceImpl
import cn.freemud.service.thirdparty.DataCenterClient
import com.alibaba.fastjson.JSON
import com.alibaba.fastjson.TypeReference
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo
import com.freemud.application.sdk.api.ordercenter.adapter.OrderCenterSdkAdapter
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto
import com.freemud.application.sdk.api.ordercenter.response.OrderBaseResp
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService
import com.freemud.sdk.api.assortment.order.adapter.OrderSdkAdapter
import spock.lang.Specification

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/2/23 17:17
 * @description : 
 */
class OrderAdapterServiceImplTest extends Specification {

    def orderServiceImpl = new OrderServiceImpl()

    def orderAdapter = new OrderAdapter(mcCafePartnerId: ["9999"], cocoPartnerId: ["9999"])

    def itemService = Mock(OrderItemServiceImpl.class)

    def orderSdkService = Mock(OrderSdkService.class)

    def dataCenterClient = Mock(DataCenterClient)
    def orderBusinessService = new OrderBusinessServiceImpl()

    def orderSdkAdapter = new OrderSdkAdapter()
    def orderCenterSdkAdapter = new OrderCenterSdkAdapter()

    def memberBlacklistHandler = new MemberBlacklistHandler()

    void setup() {
        orderServiceImpl.orderAdapter = orderAdapter
        orderServiceImpl.itemService = itemService
        orderServiceImpl.memberBlacklistHandler = memberBlacklistHandler
        memberBlacklistHandler.dataCenterClient = dataCenterClient
        orderBusinessService.orderSdkAdapter = orderSdkAdapter
        orderServiceImpl.orderBusinessService = orderBusinessService
        orderServiceImpl.memberBlacklistHandler = memberBlacklistHandler
        orderBusinessService.orderSdkService = orderSdkService
        orderSdkAdapter.orderCenterSdkAdapter = orderCenterSdkAdapter
    }

    def "测试华莱士订单问题"() {
        given: "参数设置"
        def createOrderBO = new CreateOrderBONew()
        // 接口请求信息
        String createVOStr = "{\"buyType\":0,\"channel\":\"1\",\"channelType\":\"saas\",\"couponCode\":\"88709762025965446405\",\"couponCodes\":[{\"activityCode\":\"D1639031228000490\",\"couponCode\":\"88709762025965446405\",\"couponType\":3}],\"enableSharing\":1,\"expectTime\":\"\",\"latitude\":\"31.37482\",\"longitude\":\"121.26621\",\"menuType\":\"saas\",\"mobile\":\"18868926846\",\"orderRemark\":\"\",\"orderType\":1,\"partnerId\":\"2690\",\"payChannelType\":1,\"reachStoreType\":4,\"sessionId\":\"7f19e7a7c3621f3499cc518bcf6bc3052433379a\",\"sessionKey\":\"KGrkixpMcAHYrQ6Tlnf44A==\",\"shopId\":\"QAJIALE001\",\"storeAddress\":\"南翔大润发\",\"storeName\":\"晓航的门店\",\"storeNameEn\":\"QAJIALE001\",\"tableNumber\":\"\",\"takeMealFlag\":\"0\",\"takeMealTime\":\"\",\"thirdShopId\":\"QAJIALE001\",\"useCustomerScore\":2,\"userId\":\"3653544968271672251\",\"userName\":\"时光\",\"version\":\"3.0.21.4\"}";
        def createOrderVo = JSON.parseObject(createVOStr, CreateOrderVo.class)
        createOrderBO.setCreateOrderVo(createOrderVo)
        // 登录信息
        def userLoginInfoDto = JSON.parseObject("{\"accessToken\":\"\",\"alipayUserId\":\"\",\"appId\":\"wx3f7ca0c75b213380\",\"appSecret\":\"\",\"appsecret\":\"\",\"channel\":\"1\",\"customerId\":\"\",\"devBrand\":\"\",\"devModel\":\"\",\"iappId\":\"7\",\"memberId\":\"3614319825989629832\",\"mobile\":\"17327190802\",\"newMember\":false,\"nickName\":\"SWEET SUGA\",\"openId\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"openid\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"partnerId\":\"2581\",\"photoUrl\":\"https://thirdwx.qlogo.cn/mmopen/vi_32/zahIlicTNSM0IA0qjOryv6s0SzIhlwW9EpQKvL63GbPhBwficMAibDohDEibSCQU0I5KohibIpp0yL57TWRcVKrRH2A/132\",\"registerTime\":\"2021-02-26 14:10:26\",\"sessionId\":\"cef46527f632a961af7a84209bdb8fcd0997c936\",\"sessionKey\":\"hZtQ1Usx/NhEUyoyduF+FQ==\",\"session_key\":\"hZtQ1Usx/NhEUyoyduF+FQ==\",\"storeId\":\"\",\"tableNumber\":\"\",\"thirdPartyMemberID\":\"\",\"thirdPartyPartnerID\":\"\",\"unionId\":\"o7cEm68JPFhbrzqb0a0BcQE-dDVA\",\"wxAppId\":\"wx3f7ca0c75b213380\",\"wxAppid\":\"wx3f7ca0c75b213380\"}"
                , AssortmentCustomerInfoVo.class)
        createOrderBO.setUserLoginInfoDto(userLoginInfoDto)
        //  购物车信息
        def shoppingCartGoodsDto = JSON.parseObject("{\"activityDiscountsDtos\":[{\"activityCode\":\"88709762025965446405\",\"activityName\":\"柚子3折券\",\"activityType\":31,\"discountAmount\":-97,\"priority\":60}],\"isDiscountDelivery\":false,\"originalTotalAmount\":139,\"packageAmount\":0,\"packageAmountCollectType\":1,\"products\":[{\"activityDiscountsDtos\":[{\"activityCode\":\"88709762025965446405\",\"activityName\":\"柚子3折券\",\"activityType\":31,\"actualActivityGoodsNumber\":1,\"discountAmount\":97}],\"cartGoodsUid\":\"e58094b9-412f-4c46-9278-1d81cd694fb5\",\"categoryName\":\"套餐\",\"classificationId\":\"\",\"classificationName\":\"\",\"comboProducts\":[{\"customerCode\":\"jrb\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isFixedProduct\":true,\"isMonthCard\":0,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":33,\"originalProductType\":1,\"parentProductId\":\"255176569631514924\",\"picture\":\"https://picture.sandload.cn/1628583566754.jpg\",\"productType\":6,\"qty\":1,\"skuForeignName\":\"\",\"skuId\":\"215806490097850416\",\"skuName\":\"柚子的鸡肉棒\",\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215806490097850416\",\"spuName\":\"柚子的鸡肉棒\",\"stockLimit\":true,\"tax\":0.0,\"unit\":\"\",\"weight\":0.0},{\"customerCode\":\"jrb\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isFixedProduct\":false,\"isMonthCard\":0,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":33,\"originalProductType\":1,\"parentProductId\":\"255176569631514924\",\"picture\":\"https://picture.sandload.cn/1628583566754.jpg\",\"productType\":6,\"qty\":1,\"skuForeignName\":\"\",\"skuId\":\"215806490097850416\",\"skuName\":\"柚子的鸡肉棒\",\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215806490097850416\",\"spuName\":\"柚子的鸡肉棒\",\"stockLimit\":true,\"tax\":0.0,\"totalDiscountAmount\":25,\"unit\":\"\",\"weight\":0.0},{\"customerCode\":\"hb\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isFixedProduct\":false,\"isMonthCard\":0,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":2,\"originalProductType\":1,\"parentProductId\":\"255176569631514924\",\"picture\":\"https://picture.sandload.cn/1628583887266.png\",\"productType\":6,\"qty\":1,\"skuForeignName\":\"\",\"skuId\":\"215806824348227645\",\"skuName\":\"柚子的汉堡\",\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215806824348227645\",\"spuName\":\"柚子的汉堡\",\"stockLimit\":true,\"tax\":0.0,\"totalDiscountAmount\":1,\"unit\":\"\",\"weight\":0.0},{\"customerCode\":\"gl\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isFixedProduct\":false,\"isMonthCard\":0,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":4,\"originalProductType\":1,\"parentProductId\":\"255176569631514924\",\"picture\":\"https://picture.sandload.cn/1628587383665.jpg\",\"productType\":6,\"qty\":1,\"skuForeignName\":\"\",\"skuId\":\"215810517496862722\",\"skuName\":\"柚子的果篮\",\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"215810517496862722\",\"spuName\":\"柚子的果篮\",\"stockLimit\":true,\"tax\":0.0,\"totalDiscountAmount\":2,\"unit\":\"\",\"weight\":0.0}],\"customerCode\":\"isStockLimit001\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isSendGoods\":false,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":139,\"originalProductType\":7,\"picture\":\"https://picture.sandload.cn/1666144031098.jpg\",\"productCode\":\"isStockLimit001\",\"productType\":6,\"qty\":1,\"skuForeignName\":\"\",\"skuId\":\"255176569631514924\",\"skuName\":\"迦勒套餐限制库存\",\"specialExtra\":[],\"spuForeignName\":\"\",\"spuId\":\"255176569631514924\",\"spuName\":\"迦勒套餐限制库存\",\"stockLimit\":true,\"tax\":0.0,\"totalDiscountAmount\":97,\"unit\":\"\",\"weight\":0.0}],\"reduceScore\":0,\"scoreReduceAmount\":0,\"totalAmount\":42,\"totalDiscountAmount\":97}"
                , ShoppingCartGoodsDto.class)
        createOrderBO.setShoppingCartGoodsDto(shoppingCartGoodsDto)

        //拓展信息
        def extInfo = new OrderExtInfoDto()
        createOrderBO.setExtInfo(extInfo)

        // 门店信息
        def storeMixResponseDto = JSON.parseObject("{\"businessInfo\":{\"appointAutoDeliveryTakeOrderWorkflowFinishTime\":3,\"appointAutoSelfmentionMakerWorkflowFinishTime\":4,\"appointAutoSelfmentionTakeOrderWorkflowFinishTime\":4,\"appointAutoTakeOutTakeOrderWorkflowFinishTime\":4,\"appointThirdDeliveryPickCompleteWorkflowFinishTime\":5,\"appointThirdDeliveryTakeOrderWorkflowFinishTime\":6,\"autoChargebackOrderTime\":1,\"autoChargebackOrderType\":1,\"autoDeliveryTakeOrderWorkflowFinishTime\":3,\"autoSelfmentionMakerWorkflowFinishTime\":2,\"autoSelfmentionTakeOrderWorkflowFinishTime\":2,\"autoTakeOutTakeOrderWorkflowFinishTime\":4,\"autoThirdDeliveryPickCompleteWorkflowFinishTime\":5,\"autoThirdDeliveryTakeOrderWorkflowFinishTime\":2,\"automaticRefund\":0,\"deliveryAppoint\":1,\"deliveryAppointTime\":65,\"deliveryFinishedAfterMinute\":45,\"deliveryHours\":\"00:05-23:05\",\"deliveryOrderWarnTime\":\"1\",\"deliveryProcessingAfterMinute\":60,\"deliveryProcessingBeforeMinute\":45,\"expandFields\":{\"appendMinutePerKilometer\":3,\"likesConfigValue\":0,\"likesShow\":0,\"monthlySalesConfigValue\":0,\"monthlySalesShow\":0,\"peakTimeDelivery\":[],\"preOrderSwitch\":1,\"scanOrderSwitch\":0},\"expectedTime\":30,\"goodsAvgTimeOfMaking\":5,\"id\":234288279718075653,\"invoice\":0,\"isAutoTakeOrder\":2,\"maxOrderQuantity\":100,\"minPriceForInvoice\":0,\"orderPrintConfig\":\"1\",\"orderProgressBarStatus\":2,\"orderType\":\"pickup,delivery\",\"orderWarnTime\":\"1\",\"overTimeCloseOrder\":1,\"partnerId\":\"2690\",\"pickupAutomaticOrderTime\":1,\"selfMentionSwitch\":1,\"supportCashierPay\":2,\"tableware\":0,\"takePartInSettleAccounts\":2,\"takeoutAutomaticOrderTime\":1,\"templateName\":\"test\",\"templateType\":1,\"timeOfRefund\":\"21:00:00\",\"timeTypeOfRefund\":1,\"turnOnTimeOfMaking\":2},\"storeInfo\":{\"activeFlag\":1,\"address\":\"南翔大润发\",\"briefName\":\"\",\"businessHours\":\"00:00-24:00\",\"businessHoursDay\":\"00:00-24:00\",\"businessType\":\"1\",\"city\":\"上海市\",\"delivery\":1,\"deliveryHours\":\"00:05-23:05\",\"deliveryHoursDay\":\"00:05-23:05\",\"deliveryPrice\":0.0,\"distributionScope\":\"\",\"freeDeliveryPrice\":4.0,\"isSelfMention\":1,\"latitude\":\"31.293325\",\"logoUrl\":\"https://picture.sandload.cn/1638252778564.png\",\"longitude\":\"121.304668\",\"parentCode\":\"KAQA008Kw\",\"parentId\":\"e4e7b5c5-bbf9-4330-9b60-714117936aaa\",\"parentName\":\"上海非码网络科技公司\",\"partnerId\":\"2690\",\"phone\":\"18868926846\",\"province\":\"上海市\",\"region\":\"嘉定区\",\"state\":\"1\",\"storeCode\":\"QAJIALE001\",\"storeId\":\"f51f66f9-59aa-4aca-a74b-6ca1ae6a1ab6\",\"storeName\":\"晓航的门店\",\"storeNameEn\":\"QAJIALE001\",\"thirdPartCode\":\"QAJIALE001\"}}"
                , StoreMixResponseDto.class)
        createOrderBO.setStoreMixResponseDto(storeMixResponseDto)

        // 基础服务返回订单信息
        def respOrder = JSON.parseObject("{\"code\":\"100\",\"message\":\"成功\",\"result\":{\"abnormalDesc\":\"\",\"actualPayAmount\":42,\"appId\":\"wxa1f272347828dae8\",\"barCounter\":\"\",\"bizType\":1,\"canRefund\":false,\"cancelReason\":\"\",\"companySelfCode\":\"\",\"createTime\":\"1666144461054\",\"deliveryContactInfoList\":[{\"addressDetail\":\"南翔大润发\",\"city\":\"\",\"contactsName\":\"\",\"expressNo\":\"\",\"extInfo\":\"{}\",\"infoType\":1,\"mobile\":\"18868926846\",\"province\":\"\",\"region\":\"\",\"relateObjectType\":1,\"street\":\"\",\"telephone\":\"\",\"thirdDeliveryId\":\"\"}],\"downstreamPosCode\":\"\",\"downstreamThirdOrderCode\":\"\",\"expressChannelCode\":\"\",\"expressChannelName\":\"\",\"expressNo\":\"\",\"extInfo\":\"{\\\"unpaidCloseTimeoutMinute\\\":15,\\\"openid\\\":\\\"o0wG94vYX4dU0D05UZeLr2sq2G5c\\\",\\\"appid\\\":\\\"wxa1f272347828dae8\\\",\\\"paidMember\\\":false,\\\"unpaidCloseTimeoutTimestamp\\\":1666145361054}\",\"immediately\":false,\"isParent\":false,\"localTableKey\":\"\",\"marketingCode\":\"\",\"needInvoice\":false,\"note\":\"\",\"operator\":\"时光\",\"orderArea\":\"\",\"orderClient\":2,\"orderCode\":\"25805755363268790000001\",\"orderCostDetailList\":[],\"orderExtended\":{\"agentPayerId\":\"\",\"agentPayerName\":\"\",\"orderClientGroup\":\"上海非码网络科技公司\",\"orderClientGroupCode\":\"KAQA008Kw\",\"sendWord\":\"\",\"spellGroupCode\":\"\",\"storeNameEn\":\"\",\"userPhone\":\"\"},\"orderItemList\":[{\"canRefund\":true,\"extInfo\":\"{\\\"cartGoodsUid\\\":\\\"e58094b9-412f-4c46-9278-1d81cd694fb5\\\",\\\"isB3S1Coupon\\\":0,\\\"isMonthCard\\\":0,\\\"isSendGoods\\\":false,\\\"productGroupList\\\":[{\\\"groupId\\\":\\\"251946861712302120\\\",\\\"groupName\\\":\\\"迦勒商品租\\\",\\\"thirdGroupId\\\":\\\"迦勒套餐0021\\\"}],\\\"spuProductCode\\\":\\\"123123123asdf\\\",\\\"stapleFood\\\":0,\\\"tax\\\":0.0}\",\"id\":258057553660999454,\"ignoreInOrderClose\":false,\"marketingCode\":\"\",\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"parentProductId\":\"0\",\"photoUrl\":\"\",\"productCode\":\"123123123asdf\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"255176569631514924\",\"productName\":\"迦勒套餐限制库存\",\"productPicUrl\":\"https://picture.sandload.cn/1666144031098.jpg\",\"productPrice\":139,\"productProperty\":\"\",\"productQuantity\":1,\"productSeq\":1,\"productSharePrice\":97,\"productSpec\":\"255176569631514924\",\"productSpecName\":\"迦勒套餐限制库存\",\"productSpuQuantity\":1,\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"salePrice\":42,\"settlementPrice\":42,\"thirdProductId\":\"isStockLimit001\",\"userId\":\"\",\"weight\":0.0},{\"canRefund\":true,\"extInfo\":\"{\\\"isB3S1Coupon\\\":0,\\\"isFixedProduct\\\":true,\\\"isMonthCard\\\":0,\\\"productGroupList\\\":[{\\\"groupId\\\":\\\"251946861712302120\\\",\\\"groupName\\\":\\\"迦勒商品租\\\",\\\"thirdGroupId\\\":\\\"迦勒套餐0021\\\"}],\\\"spuProductCode\\\":\\\"5566\\\",\\\"tax\\\":0.0}\",\"id\":258057553667290912,\"ignoreInOrderClose\":false,\"marketingCode\":\"\",\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"parentProductId\":\"255176569631514924_1\",\"photoUrl\":\"\",\"productCode\":\"5566\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"215806490097850416\",\"productName\":\"柚子的鸡肉棒\",\"productPicUrl\":\"https://picture.sandload.cn/1628583566754.jpg\",\"productPrice\":33,\"productProperty\":\"\",\"productQuantity\":1,\"productSeq\":2,\"productSharePrice\":0,\"productSpec\":\"215806490097850416\",\"productSpecName\":\"柚子的鸡肉棒\",\"productSpuQuantity\":1,\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"salePrice\":33,\"settlementPrice\":33,\"thirdProductId\":\"jrb\",\"userId\":\"\",\"weight\":0.0},{\"canRefund\":true,\"extInfo\":\"{\\\"isB3S1Coupon\\\":0,\\\"isFixedProduct\\\":false,\\\"isMonthCard\\\":0,\\\"productGroupList\\\":[{\\\"groupId\\\":\\\"251946861712302120\\\",\\\"groupName\\\":\\\"迦勒商品租\\\",\\\"thirdGroupId\\\":\\\"迦勒套餐0021\\\"}],\\\"spuProductCode\\\":\\\"5566\\\",\\\"tax\\\":0.0}\",\"id\":258057553674630946,\"ignoreInOrderClose\":false,\"marketingCode\":\"\",\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"parentProductId\":\"255176569631514924_1\",\"photoUrl\":\"\",\"productCode\":\"5566\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"215806490097850416\",\"productName\":\"柚子的鸡肉棒\",\"productPicUrl\":\"https://picture.sandload.cn/1628583566754.jpg\",\"productPrice\":33,\"productProperty\":\"\",\"productQuantity\":1,\"productSeq\":3,\"productSharePrice\":25,\"productSpec\":\"215806490097850416\",\"productSpecName\":\"柚子的鸡肉棒\",\"productSpuQuantity\":1,\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"salePrice\":8,\"settlementPrice\":8,\"thirdProductId\":\"jrb\",\"userId\":\"\",\"weight\":0.0},{\"canRefund\":true,\"extInfo\":\"{\\\"isB3S1Coupon\\\":0,\\\"isFixedProduct\\\":false,\\\"isMonthCard\\\":0,\\\"productGroupList\\\":[{\\\"groupId\\\":\\\"251946861712302120\\\",\\\"groupName\\\":\\\"迦勒商品租\\\",\\\"thirdGroupId\\\":\\\"迦勒套餐0021\\\"}],\\\"spuProductCode\\\":\\\"445533\\\",\\\"tax\\\":0.0}\",\"id\":258057553681970980,\"ignoreInOrderClose\":false,\"marketingCode\":\"\",\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"parentProductId\":\"255176569631514924_1\",\"photoUrl\":\"\",\"productCode\":\"445533\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"215806824348227645\",\"productName\":\"柚子的汉堡\",\"productPicUrl\":\"https://picture.sandload.cn/1628583887266.png\",\"productPrice\":2,\"productProperty\":\"\",\"productQuantity\":1,\"productSeq\":4,\"productSharePrice\":1,\"productSpec\":\"215806824348227645\",\"productSpecName\":\"柚子的汉堡\",\"productSpuQuantity\":1,\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"salePrice\":1,\"settlementPrice\":1,\"thirdProductId\":\"hb\",\"userId\":\"\",\"weight\":0.0},{\"canRefund\":true,\"extInfo\":\"{\\\"isB3S1Coupon\\\":0,\\\"isFixedProduct\\\":false,\\\"isMonthCard\\\":0,\\\"productGroupList\\\":[{\\\"groupId\\\":\\\"251946861712302120\\\",\\\"groupName\\\":\\\"迦勒商品租\\\",\\\"thirdGroupId\\\":\\\"迦勒套餐0021\\\"}],\\\"spuProductCode\\\":\\\"776655\\\",\\\"tax\\\":0.0}\",\"id\":258057553688262438,\"ignoreInOrderClose\":false,\"marketingCode\":\"\",\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"parentProductId\":\"255176569631514924_1\",\"photoUrl\":\"\",\"productCode\":\"776655\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"215810517496862722\",\"productName\":\"柚子的果篮\",\"productPicUrl\":\"https://picture.sandload.cn/1628587383665.jpg\",\"productPrice\":4,\"productProperty\":\"\",\"productQuantity\":1,\"productSeq\":5,\"productSharePrice\":2,\"productSpec\":\"215810517496862722\",\"productSpecName\":\"柚子的果篮\",\"productSpuQuantity\":1,\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"salePrice\":2,\"settlementPrice\":2,\"thirdProductId\":\"gl\",\"userId\":\"\",\"weight\":0.0}],\"orderSettlementDetailList\":[{\"extInfo\":\"\",\"externalObjectId\":\"88709762025965446405\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"柚子3折券\",\"number\":1,\"productId\":\"\",\"settlementAmount\":-97,\"settlementType\":208,\"shopDiscountAmount\":-97},{\"extInfo\":\"\",\"externalObjectId\":\"88709762025965446405\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"柚子3折券\",\"number\":1,\"productId\":\"255176569631514924\",\"productSeq\":1,\"settlementAmount\":97,\"settlementType\":208,\"shopDiscountAmount\":97},{\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":1,\"productId\":\"255176569631514924\",\"productSeq\":1,\"settlementAmount\":97,\"settlementType\":0,\"shopDiscountAmount\":97},{\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":1,\"productId\":\"215806490097850416\",\"productSeq\":3,\"settlementAmount\":25,\"settlementType\":0,\"shopDiscountAmount\":25},{\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":1,\"productId\":\"215806824348227645\",\"productSeq\":4,\"settlementAmount\":1,\"settlementType\":0,\"shopDiscountAmount\":1},{\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":1,\"productId\":\"215810517496862722\",\"productSeq\":5,\"settlementAmount\":2,\"settlementType\":0,\"shopDiscountAmount\":2},{\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"优惠总金额\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":0,\"platformDiscountAmount\":0,\"productId\":\"0\",\"productSeq\":0,\"settlementAmount\":42,\"settlementType\":205,\"shopDiscountAmount\":97}],\"orderState\":1,\"orderType\":5,\"originalAmount\":139,\"parentCode\":\"\",\"partnerId\":\"2690\",\"partnerName\":\"\",\"payChannel\":\"10211\",\"payChannelName\":\"微信\",\"payChannelType\":\"1\",\"payRequestNo\":\"\",\"payType\":1,\"pickUpGoodsNo\":\"\",\"posCode\":\"\",\"posTableKey\":\"\",\"settlementAmount\":42,\"storeId\":\"QAJIALE001\",\"storeName\":\"晓航的门店\",\"storeUnifyId\":\"\",\"suspendDesc\":\"\",\"thirdOrderCode\":\"25805755363268790000001\",\"thirdStoreId\":\"QAJIALE001\",\"toStoreId\":\"\",\"userId\":\"3653544968271672251\",\"userMobile\":\"18868926846\",\"userName\":\"时光\",\"weight\":0.0},\"ver\":\"1\"}"
                , new TypeReference<OrderBaseResp<OrderInfoReqs>>() {})

        and: "默认值设置"
        memberBlacklistHandler.checkisTrueBlacklist(_) >> null
        orderSdkService.createOrder(_, _) >> respOrder
        when: "调用方法"
        def order = orderServiceImpl.sdkCreateOrder(createOrderBO)

        then: "验证"

    }

}
