package cn.freemud.adapter;

import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.ordercenter.enums.AfterSalesType;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.sdk.api.assortment.order.enums.AfterSalesRefunStateEnum;
import com.freemud.sdk.api.assortment.order.enums.OperationClientEnum;
import com.freemud.sdk.api.assortment.order.request.order.CancelOrderRequest;
import com.freemud.sdk.api.assortment.order.request.order.V2CancelOrderRequest;
import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;

public class V2CancelOrderRequestAdapter {

    public static V2CancelOrderRequest convert(OrderInfoReqs order, Long refundAmount, AfterSalesType afterSalesType, String reason, String remark, Boolean refundDeliveryFee, Byte refundMode) {
        V2CancelOrderRequest req = new V2CancelOrderRequest();
        req.setPartnerId(order.getPartnerId());

        req.setOperator(order.getUserName());
        if (AfterSalesType.SYSTEM_CANCEL.getIndex().equals(afterSalesType.getIndex())) {
            req.setOperator("admin");
            req.setOperationClient(OperationClientEnum.STATE_6.getIndex().byteValue());
        }

        req.setOrderCode(order.getOrderCode());
        req.setReqAmount(new BigDecimal(refundAmount));
        req.setOrderClient(order.getOrderClient().byteValue());
        req.setOperationClient(OperationClientEnum.STATE_5.getIndex().byteValue());

        if (StringUtils.isNotBlank(reason) && reason.length() > 50) {
            reason = reason.substring(0, 50);
        }
        req.setAfterSalesReason(reason);
        req.setCancelReason(reason);
        req.setReqRemark(remark);

        req.setAfterSalesType(afterSalesType.getIndex().byteValue());

        // 这里给默认值,外面调用者 自己的根据业务判断退款 状态
        req.setRefundState(AfterSalesRefunStateEnum.STATE_1.getIndex().byteValue());
        req.setRefundDeliveryAmount(refundDeliveryFee);
        // 商城订单 增加拓展信息
        CancelOrderRequest.AfterSalesOrderExtInfoReq ext = new CancelOrderRequest.AfterSalesOrderExtInfoReq();
        ext.setRefundMode(refundMode);
        req.setExtInfo(JSON.toJSONString(ext));
        return req;
    }
}
