package cn.freemud.service.impl;

import cn.freemud.service.OrderDistributeMQService;
import com.freemud.sdk.api.assortment.orderdistributor.request.DisRequest;
import com.freemud.sdk.api.assortment.orderdistributor.service.OrderDistributionService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: $微信订单上送MQ分发器服务接口
 * @author: aiqi.gong
 * @date: 2019/3/21 18:37
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
@Slf4j
public class WechatOrderPushDistributeMQServiceImpl implements OrderDistributeMQService {

    @Autowired
    private OrderDistributionService orderDistributionService;

    @Override
    public void messageDistribute(DisRequest disRequest) {
        try {
            orderDistributionService.pushOrder(disRequest);
        }catch (Exception e){
            log.error("OrderDistributeMQServiceImpl MQ消息发送失败",e.getMessage());
        }
    }


}
