/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: StroeControllerTest
 * @Package cn.freemud.controller
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/14 9:45
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.controller;

import cn.freemud.OrderApplication;
import cn.freemud.entities.vo.NearStoreRequest;
import cn.freemud.entities.vo.StoreInfoRequestVo;
import com.alibaba.fastjson.JSONObject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = OrderApplication.class)
public class StroeControllerTest {
    @Autowired
    private WebApplicationContext wac;
    private MockMvc mockMvc;

    @Before
    public void setUp() {
        mockMvc = MockMvcBuilders.webAppContextSetup(wac).build();
    }


    @Test
    public void testFindNearStores () {

        NearStoreRequest request = new NearStoreRequest();
        request.setPartnerId("30b5f0ca-399a-4be3-9063-12a3d2622a38");
        request.setLatitude("31.26451");
        request.setLongitude("121.50515");
        request.setPageNo(1);
        request.setPageSize(5);
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/store/findNearStores").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGetStoreInfo () {
        StoreInfoRequestVo request = new StoreInfoRequestVo();
        request.setPartnerId("30b5f0ca-399a-4be3-9063-12a3d2622a38");
        request.setShopId("1450174");
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/store/getStoreInfo").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
