package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.parking.QueryParkingOrderVo;
import cn.freemud.service.ParkingOrderService;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ParkingOrderController
 * @Package cn.freemud.controller
 * @Description:
 * @author: ping1.wu
 * @date: 2020/7/3 15:14
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RequestMapping("/order")
@RestController
@Validated
public class ParkingOrderController {

    @Autowired
    private ParkingOrderService parkingOrderService;

    /**
     * 查询停车订单列表
     */
    @ApiAnnotation(logMessage = "queryParkingOrders")
    @PostMapping("/queryParkingOrders")
    public BaseResponse queryParkingOrders(@Validated @LogParams @RequestBody QueryParkingOrderVo requestVo) {
        return parkingOrderService.queryOrders(requestVo);
    }

    /**
     * 获取停车订单详情
     */
    @ApiAnnotation(logMessage = "queryParkingOrderById")
    @PostMapping("/queryParkingOrderById")
    public BaseResponse queryParkingOrderById(@Validated @LogParams @RequestBody QueryParkingOrderVo requestVo) {
        return parkingOrderService.queryOrderById(requestVo);
    }

}
