package cn.freemud.enums;

/**
 * 小程序开通状态
 *
 * @author liming.guo
 * @date 2018/05/10
 */
public enum WxappStatus {

    AUDIT(0, "待审核"), OPEN(1, "已开通"), CLOSE(2, "已关闭");

    private Integer code;
    private String message;

    WxappStatus(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public static WxappStatus getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (WxappStatus status : values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
