package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.QueryStateMonitorInfoResp;
import cn.freemud.entities.vo.OrderStateMonitorInfoVo;
import cn.freemud.service.Orderservice;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 订单状态监控查询
 *
 * @version: 1.0
 * @Description: TODO
 * @author: wangshichang
 * @date: 2021/5/13 下午4:01
 * @Copyright: www.freemud.cn Inc.
 */
@Api(tags = "订单状态监控")
@Slf4j
@Validated
@RequestMapping("/order")
@RestController
public class OrderReportController {


    private final Orderservice orderservice;

    public OrderReportController(Orderservice orderservice) {
        this.orderservice = orderservice;
    }


    /**
     * 订单状态监控查询
     * <p>用于提供给监控系统查询</p>
     *
     * @param queryResp 查询参数
     * @return {@link BaseResponse< OrderStateMonitorInfoVo >}
     */
    @ApiAnnotation(logMessage = "queryOrderStateMonitorInfo")
    @GetMapping("/stateMonitorInfo")
    public BaseResponse<OrderStateMonitorInfoVo> queryOrderStateMonitorInfo(@Validated QueryStateMonitorInfoResp queryResp) {
        return orderservice.queryOrderStateMonitorInfo(queryResp.getOrderCode(), queryResp.getPartnerId(), queryResp.getOrderClient());
    }


}
