package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.vo.*;

import java.util.Map;

/**
 * 用户服务
 *
 * @author liming.guo
 * @date 2018/05/08
 */
public interface UserService {


    /**
     * 获取用户登陆sessionid
     */
    BaseResponse<UserLoginVo> getSessionId(GetUserLoginSessionIdVo requestUserLoginVo);

    /**
     * 获取用户登陆sessionid
     */
    BaseResponse<UserLoginVo> getUserInfo(GetUserLoginSessionIdVo requestUserLoginVo);

    /**
     * 获取用户手机号一键授权登陆
     */
    BaseResponse<UserLoginVo> getPhoneNumber(GetPhoneNumberVo phoneNumberVo);

    /**
     * 发送验证码信息
     */
    BaseResponse sendSmsCode(SendSmsCodeVo sendSmsCodeVo);

    /**
     * 用户通过手机号注册
     */
    BaseResponse registerByMobile(RegisterByMobileVo registerByMobileVo);

    /**
     * 用户修改手机号
     */
    BaseResponse editMobile(EditMobileVo editMobileVo);

    /**
     * 获取用户收获地址
     */
    BaseResponse getDeliveryAddress(QueryDeliveryAddressVo queryDeliveryAddressVo);

    /**
     * 保存用户收货地址
     */
    BaseResponse addDeliveryAddress(AddDeliveryAddressVo addDeliveryAddressVo);

    /**
     * 删除用户收货地址
     */
    BaseResponse deleteDeliveryAddress(DeleteDeliveryAddressVo deleteDeliveryAddressVo);

    /**
     * 获取用户会话sessionId 开放给其他小程序使用（拼团，会员)
     */
    BaseResponse<OpenUserInfoVo> getOpenSessionid(GetUserLoginSessionIdVo getUserLoginSessionIdVo);

    /**
     * 更新用户昵称接口
     */
    BaseResponse updateNickName(UpdateNickNameVo updateNickNameVo);

    /**
     *
     */
    BaseResponse getOpenUserInfo(GetOpenUserInfoVo getOpenUserInfoVo);


    BaseResponse<RegisterByUnionIdResponseVo> registerByUnionId(RegisterByUnionIdRequestVo registerByUnionIdRequestVo);

    Map<String, Object> getUserInfoMapBySessionId(String sessionId);

    /**
     * 获取缓存用户信息
     *
     * @param sessionId
     * @return
     */
    UserLoginInfoDto getUserLoginInfoBySessionId(String sessionId);

    /**
     * 获取当前版本，确认版本信息
     */

}
