package cn.freemud.controller;

import cn.freemud.ShoppingCartApplication;
import cn.freemud.entities.vo.NearStoreRequest;
import cn.freemud.entities.vo.StoreInfoRequestVo;
import com.alibaba.fastjson.JSONObject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: StoreControllerTest
 * @Package cn.freemud.controller
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/6/25 18:51
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = ShoppingCartApplication.class)
public class StoreControllerTest {
    @Autowired
    private WebApplicationContext wac;
    private MockMvc mockMvc;

    @Before
    public void setUp() {
        mockMvc = MockMvcBuilders.webAppContextSetup(wac).build();
    }

    /**
     * 查询附近门店
     */
    @Test
    public void findNearStores () {
        NearStoreRequest nearStoreRequest = new NearStoreRequest();
        nearStoreRequest.setLatitude("22.534");
        nearStoreRequest.setLongitude("114.058");
        nearStoreRequest.setPageNo(1);
        nearStoreRequest.setPageSize(2);
        nearStoreRequest.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        nearStoreRequest.setDistance("20");
        String str = JSONObject.toJSONString(nearStoreRequest);
        try {
            mockMvc.perform(post("/store/findNearStores").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * 查询单个门店信息
     */
    @Test
    public void getStoreInfo () {
        StoreInfoRequestVo storeInfoRequestVo = new StoreInfoRequestVo();
        storeInfoRequestVo.setShopId("1036");
        storeInfoRequestVo.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        String str = JSONObject.toJSONString(storeInfoRequestVo);
        try {
            mockMvc.perform(post("/store/getStoreInfo").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
