package cn.freemud.entities.dto.activity;

import lombok.Data;

/**
 * 满减信息
 */
@Data
public class FullSubtractionActivityDto {

    /**
     * 活动code
     */
    private String activityCode;
    /**
     * 活动描述
     */
    private String activityDesc;
    /**
     * 满减活动名称
     */
    private String activityName;
    /**
     * 0 未启用 1 已启用 2 已结束 PromotionActivityStatus
     */
    private Integer activityStatus;
    /**
     * 活动类型 阶梯满减 12  每满减11 ActivityTypeEnum
     */
    private Integer activityType;
    /**
     * 0 未审核  1 审核通过  2审核不通过
     */
    private Integer auditStatus;


    private static class Benefit {
        /**
         * 满减活动名称
         */
        private String benefitName;
        /**
         * 满多少钱 单位分
         */
        private Long thresholdAmount;
        /**
         * 减多少钱
         */
        private Long discountAmount;
        /**
         * 第几条阶梯 1,2
         */
        private Integer benefitSeq;


    }

}
