package cn.freemud.entities.dto.product.info;

import cn.freemud.entities.dto.BindingCouponTypeDto;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
public class ProductBean {

    private String barcode;
    private String brandId;
    private String brandName;
    private String category;
    private String categoryName;
    private String companyId;

    /**
     * 加料最大限购
     */
    private Integer maxNum;

    /**
     * 加料最小限购
     */
    private Integer minNum;
    private String customerCode;
    /**
     * 最终价格 单位分
     */
    private Long finalPrice;
    /**
     * 是否是SKU商品  1是0否
     */
    private Integer isSkuProduct;
    private String name;
    private String foreignName;
    /**
     * 原始价格 单位分
     */
    private Long originalPrice;
    /**
     * 包装费 单位分
     */
    private Long packPrice;

    private String picture;
    /**
     * 商品id， 单规格为spuId，多规格为skuId
     */
    private String pid;
    /**
     * 商品父id， 多规格商品，该字段为多规格的spuId
     */
    private String specProductId;
    private Integer pknumber;
    private String productionLocation;
    private String remark;
    private Integer saleCount;
    private String sellTimeName;
    private Integer sequence;
    private String sourceChannel;
    private String specification;
    private Integer status;
    private Integer stock;
    private Integer stockLimit;
    /**
     * type=10 多规格  type=1 单规格
     */
    private int type;
    /**
     * 是否是称重商品 1、表示为称重
     */
    private Integer weightType;
    /**
     * 重量,最多四位小数，单位kg
     */
    private Double weight;
    /**
     * 税率代码
     */
    private String taxId;

    /**
     * 税率
     */
    private Double tax;

    private String unit;
    private int updateStatus;
    private boolean valid;
    private int version;
    private List<ProductLabelNameListBean> labelNames;
    private List<ProductAttributeGroupListBean> productAttributeGroupList;
    private List<?> productGroupList;
    private List<ProductPictureListBean> productPictureList;
    private List<?> productSpecification;
    private List<?> sellTimeList;
    private List<?> specificationList;
    //SKU
    private List<SkuProductBean> skuList;
    //规格信息
    private List<SpecificationGroupBean> specificationGroupList;
    //Sku 规格 如果 当前是sku 则有值
    private List<SkuSpecValue> skuSpecValues;

    /**
     * 虚拟商品 绑定的券信息
     */
    private List<BindingCouponTypeDto> productBindingCouponTypes;

    /**
     *  【订C，“POS编码”让凌顶那边去匹配商品】 https://www.tapd.cn/43862731/prong/stories/view/1143862731001039549
     */
    private String linkedId;

    /**
     * 商品是否可以单点
     * 0-可单点
     * 1-不可单点
     */
    private Integer singleOrder;

    @NoArgsConstructor
    @Data
    public static class SpecificationGroupBean {
        private String partnerId;
        private Integer sequence;
        private String specId;
        private String specName;
        private String foreignSpecName;
        private List<SpecValueVo> specValueVos;

        @NoArgsConstructor
        @Data
        public static class SpecValueVo {
            private Integer sequence;
            private String specId;
            private String specValue;
            private String foreignSpecValue;
            private String specValueId;
        }
    }

    @NoArgsConstructor
    @Data
    public static class ProductLabelNameListBean {
        private String id;
        private String name;
        private String foreignName;
        private String partnerId;
        List<?> productList;
        private String storeId;
        private String type;
    }



}