package cn.freemud.enums;

public enum CouponOrderRefundFailTypeEnum {

    SUCCESS(0, "成功"),
    ORDER_VERIFY_FAIL(1, "订单校验失败"),
    COUPON_PROCESS_FAIL(2, "优惠券处理失败"),
    OTHER(7, "其他"),
    ;

    private Integer code;
    private String desc;

    CouponOrderRefundFailTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponOrderRefundFailTypeEnum getByCode(Integer code) {
        for (CouponOrderRefundFailTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
