package cn.freemud.demo.factory;

import cn.freemud.demo.enums.BizTypeEnum;
import cn.freemud.demo.service.impl.*;
import cn.freemud.utils.ApplicationContextWareBean;

public class ServiceFactory {

    public static AbstractAddGoodsService createAddGoodsServiceInstance(String bizType) {
        AbstractAddGoodsService abstractAddGoodsService;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            abstractAddGoodsService = ApplicationContextWareBean.getBean(MCoffeeAddGoodsService.class);
        } else {
            abstractAddGoodsService = ApplicationContextWareBean.getBean(PlatformAddGoodsService.class);
        }
        return abstractAddGoodsService;
    }


    public static AbstractUpdateGoodsQtyService createUpdateGoodsQtyServiceInstance(String bizType) {
        AbstractUpdateGoodsQtyService abstractUpdateGoodsQtyService = null;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            // abstractUpdateGoodsQtyService = ApplicationContextWareBean.getBean(MCoffeeAddGoodsService.class);
        } else {
            abstractUpdateGoodsQtyService = ApplicationContextWareBean.getBean(AbstractUpdateGoodsQtyService.class);
        }
        return abstractUpdateGoodsQtyService;
    }


    public static AbstractListCartGoodsService createListCartGoodsServiceInstance(String bizType) {
        AbstractListCartGoodsService abstractListCartGoodsService = null;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            // abstractUpdateGoodsQtyService = ApplicationContextWareBean.getBean(MCoffeeAddGoodsService.class);
        } else {
            abstractListCartGoodsService = ApplicationContextWareBean.getBean(AbstractListCartGoodsService.class);
        }
        return abstractListCartGoodsService;
    }


    public static AbstractApportionService createGetShoppingCartGoodsApportionServiceInstance(String bizType) {
        AbstractApportionService abstractGetShoppingCartGoodsApportionService = null;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            // abstractUpdateGoodsQtyService = ApplicationContextWareBean.getBean(MCoffeeAddGoodsService.class);
        } else {
            abstractGetShoppingCartGoodsApportionService = ApplicationContextWareBean.getBean(AbstractApportionService.class);
        }
        return abstractGetShoppingCartGoodsApportionService;
    }


}
