/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/18 18:09
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "CART-SERVICE",url = "${saas.shoppingcartclient.feign.url}")
@RequestMapping(value = "/cart",produces = {"application/json;charset=UTF-8"})
public interface ShoppingCartClient {

    /**
     * 购物车添加商品
     * @param request
     * @return
     */
    @PostMapping(value = "/add?lang=zh_CN")
    ShoppingCartInfoDto addShoppingCart(@RequestBody AddShoppingCartRequestDto request);

    /**
     * 修改购物车商品数量
     * @param request
     * @return
     */
    @PostMapping(value = "/updateCartInfo?lang=zh_CN")
    ShoppingCartBaseResponse updateShoppingCart(@RequestBody UpdateShoppingCartRequestDto request);

    /**
     * 查询购物商品
     * @param request
     * @return
     */
    @PostMapping(value = "/detail?lang=zh_CN")
    ShoppingCartInfoDto getShoppingCart(@RequestBody GetShoppingCartDto request);


    /**
     * 清空购物车
     * @param request
     * @return
     */
    @PostMapping(value = "/clear?lang=zh_CN")
    ShoppingCartBaseResponse clearShoppingCart(@RequestBody ClearShoppingCartRequestDto request);

    /**
     * 删除购物车一个商品
     * @param request
     * @return
     */
    @PostMapping(value = "/remove?lang=zh_CN")
    ShoppingCartBaseResponse removeProduct(@RequestBody RemoveShoppingCartRequestDto request);

}
