///**
// * All rights Reserved, Designed By www.freemud.cn
// *
// * @Title: WebUtil
// * @Package cn.freemud.util
// * @Description:
// * @author: liming.guo
// * @date: 2018/7/20 18:14
// * @version V1.0
// * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
// * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
// */
//package cn.freemud.utils;
//
//import org.apache.commons.lang.StringUtils;
//
//import java.awt.geom.Point2D;
//import java.util.List;
//
//public class WebUtil {
//
//    private static final double EARTH_RADIUS = 6378137;
//
//    /**
//     * 计算坐标之间的距离，单位为米
//     */
//    public static double calDistance(double lng1, double lat1, double lng2,
//                                     double lat2) {
//        double radLat1 = lat1 * Math.PI / 180.0;
//        double radLat2 = lat2 * Math.PI / 180.0;
//        double a = radLat1 - radLat2;
//        double b = (lng1 * Math.PI / 180.0) - (lng2 * Math.PI / 180.0);
//        double s = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2), 2)
//                + Math.cos(radLat1) * Math.cos(radLat2)
//                * Math.pow(Math.sin(b / 2), 2)));
//        s = s * EARTH_RADIUS;
//        s = Math.round(s * 10000) / 10000;
//        return s;
//    }
//
//    /**
//     * 格式化距离
//     *
//     * @param distance 单位:米
//     * @return
//     */
//    public static String formatDistance(Double distance) {
//        if (distance == null || distance <= 0) {
//            return StringUtils.EMPTY;
//        }
//        if (distance < 1000) {
//            return String.format("%.0fm", distance);
//        } else if (distance < 10 * 1000) {
//            return String.format("%.1fkm", distance / 1000);
//        } else if (distance < 500 * 1000) {
//            return String.format("%.0fkm", distance / 1000);
//        } else {
//            return ">500km";
//        }
//    }
//
//
//    /**
//     * 判断点是否在多边形内
//     *
//     * @param point 检测点
//     * @param pts   多边形的顶点
//     * @return 点在多边形内返回true, 否则返回false
//     */
//    public static boolean IsPtInPoly(Point2D.Double point, List<Point2D.Double> pts) {
//
//        int N = pts.size();
//        boolean boundOrVertex = true; //如果点位于多边形的顶点或边上，也算做点在多边形内，直接返回true
//        int intersectCount = 0;
//        double precision = 2e-10; //浮点类型计算时候与0比较时候的容差
//        Point2D.Double p1, p2;
//        Point2D.Double p = point; //当前点
//
//        p1 = pts.get(0);
//        for (int i = 1; i <= N; ++i) {
//            if (p.equals(p1)) {
//                return boundOrVertex;
//            }
//
//            p2 = pts.get(i % N);
//            if (p.x < Math.min(p1.x, p2.x) || p.x > Math.max(p1.x, p2.x)) {
//                p1 = p2;
//                continue;
//            }
//
//            if (p.x > Math.min(p1.x, p2.x) && p.x < Math.max(p1.x, p2.x)) {
//                if (p.y <= Math.max(p1.y, p2.y)) {
//                    if (p1.x == p2.x && p.y >= Math.min(p1.y, p2.y)) {
//                        return boundOrVertex;
//                    }
//
//                    if (p1.y == p2.y) {
//                        if (p1.y == p.y) {
//                            return boundOrVertex;
//                        } else {
//                            ++intersectCount;
//                        }
//                    } else {
//                        double xinters = (p.x - p1.x) * (p2.y - p1.y) / (p2.x - p1.x) + p1.y;
//                        if (Math.abs(p.y - xinters) < precision) {
//                            return boundOrVertex;
//                        }
//
//                        if (p.y < xinters) {
//                            ++intersectCount;
//                        }
//                    }
//                }
//            } else {
//                if (p.x == p2.x && p.y <= p2.y) {
//                    Point2D.Double p3 = pts.get((i + 1) % N);
//                    if (p.x >= Math.min(p1.x, p3.x) && p.x <= Math.max(p1.x, p3.x)) {
//                        ++intersectCount;
//                    } else {
//                        intersectCount += 2;
//                    }
//                }
//            }
//            p1 = p2;
//        }
//
//        if (intersectCount % 2 == 0) {//偶数在多边形外
//            return false;
//        } else { //奇数在多边形内
//            return true;
//        }
//
//    }
//
//    public static Object formatAmount(Double amount) {
//        if (amount % (amount.intValue()) == 0.0) {
//            return amount.intValue();
//        } else {
//            return amount;
//        }
//    }
//
//
//}
