package com.freemud.sdk.api.assortment.order.adapter;

import com.freemud.api.assortment.datamanager.order.vo.DMOrderItemVo;
import com.freemud.api.assortment.datamanager.order.vo.DMOrderVo;
import com.freemud.sdk.api.assortment.order.request.order.AssortmentSdkUpdateOrderProductInfoRequest;
import com.freemud.sdk.api.assortment.order.request.order.CreateOrderProductRequest;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

public class OrderAssortmentDtoConvertToDMVoAdapter {
    public static DMOrderVo convertAssortmentSdkUpdateOrderProductInfoRequestToDMOrderVo(AssortmentSdkUpdateOrderProductInfoRequest updateOrderProductInfoRequest){
        DMOrderVo dmOrderVo=new DMOrderVo();
        dmOrderVo.setOrderCode(updateOrderProductInfoRequest.getOrderCode());
        dmOrderVo.setPartnerId(updateOrderProductInfoRequest.getPartnerId());
        List<DMOrderItemVo> dmOrderItemVos=new ArrayList<>();
        updateOrderProductInfoRequest.getOrderItemList().forEach(createOrderProductRequest -> {
            DMOrderItemVo dmOrderItemVo = convertCreateOrderProductRequest(createOrderProductRequest);
            if(CollectionUtils.isNotEmpty(createOrderProductRequest.getComboProduct())){
                List<DMOrderItemVo> comboOrderItemVo=new ArrayList<>();
                createOrderProductRequest.getComboProduct().forEach(each->{
                    DMOrderItemVo dmOrderItemVo1 = convertCreateOrderProductRequest(each);
                    comboOrderItemVo.add(dmOrderItemVo1);
                });
                dmOrderItemVo.setComboProduct(comboOrderItemVo);
            }
            dmOrderItemVos.add(dmOrderItemVo);
        });
        dmOrderVo.setOrderItemVos(dmOrderItemVos);
        return dmOrderVo;
    }

    public static DMOrderItemVo convertCreateOrderProductRequest(CreateOrderProductRequest createOrderProductRequest){
        DMOrderItemVo dmOrderItemVo=new DMOrderItemVo();
        dmOrderItemVo.setAddInfo(createOrderProductRequest.getAddInfo());
        dmOrderItemVo.setForeignAddInfo(createOrderProductRequest.getForeignAddInfo());
        dmOrderItemVo.setCategoryId(createOrderProductRequest.getCategoryId());
        dmOrderItemVo.setCategoryName(createOrderProductRequest.getCategoryName());
        dmOrderItemVo.setCustomerCode(createOrderProductRequest.getCustomerCode());
        dmOrderItemVo.setDiscountId(createOrderProductRequest.getDiscountId());
        dmOrderItemVo.setExtras(createOrderProductRequest.getExtras());
        dmOrderItemVo.setForeignExtras(createOrderProductRequest.getForeignExtras());
        dmOrderItemVo.setHasStockProduct(createOrderProductRequest.getHasStockProudct());
        dmOrderItemVo.setWeight(createOrderProductRequest.getWeight());
        dmOrderItemVo.setUnit(createOrderProductRequest.getUnit());
        dmOrderItemVo.setTotalDiscountAmount(createOrderProductRequest.getTotalDiscountAmount());
        dmOrderItemVo.setSpecificationName(createOrderProductRequest.getSpecificationName());
        dmOrderItemVo.setSequence(createOrderProductRequest.getSequence());
        dmOrderItemVo.setSalePrice(createOrderProductRequest.getSalePrice());
        dmOrderItemVo.setProductType(createOrderProductRequest.getProductType());
        dmOrderItemVo.setProductName(createOrderProductRequest.getProductName());
        dmOrderItemVo.setProductId(createOrderProductRequest.getProductId());
        dmOrderItemVo.setProductCode(createOrderProductRequest.getProductCode());
        dmOrderItemVo.setPrice(createOrderProductRequest.getPrice());
        dmOrderItemVo.setPicture(createOrderProductRequest.getPicture());
        dmOrderItemVo.setParentProductId(createOrderProductRequest.getParentProductId());
        dmOrderItemVo.setOpid(createOrderProductRequest.getOpid());
        dmOrderItemVo.setNumber(createOrderProductRequest.getNumber());
        dmOrderItemVo.setIgnoreProductPrice(createOrderProductRequest.getIgnoreProductPrice());
        dmOrderItemVo.setId(createOrderProductRequest.getId());
        dmOrderItemVo.setIsDeleted(createOrderProductRequest.getIsDeleted());
        return dmOrderItemVo;
    }
}
