package cn.freemud.controller;

import cn.freemud.ShoppingCartApplication;
import cn.freemud.entities.vo.*;
import com.alibaba.fastjson.JSONObject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import java.util.ArrayList;
import java.util.List;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ShoppingCartControllerTest
 * @Package cn.freemud.controller
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/6/25 17:30
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = ShoppingCartApplication.class)
public class ShoppingCartControllerTest {
    @Autowired
    private WebApplicationContext wac;
    private MockMvc mockMvc;

    @Before
    public void setUp() {
        mockMvc = MockMvcBuilders.webAppContextSetup(wac).build();
    }

    /**
     * 购物车提交
     */
    @Test
    public void submit() {
        ShoppingCartAddRequestVo shoppingCartAddRequestVo = new ShoppingCartAddRequestVo();
        shoppingCartAddRequestVo.setSessionId("107001391351857666");
        shoppingCartAddRequestVo.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        shoppingCartAddRequestVo.setShopId("1036");
        List<ShoppingCartProductVo> shoppingCartProductVoList = new ArrayList<ShoppingCartProductVo>();
        ShoppingCartProductVo shoppingCartProductVo = new ShoppingCartProductVo();
        shoppingCartProductVo.setProductId("108626130583421196");
        shoppingCartProductVo.setQty(1);
        List<ExtraProductVo> extraProductVoList = new ArrayList<ExtraProductVo>();
        ExtraProductVo extraProductVo = new ExtraProductVo();
        extraProductVo.setGroupId("107901118794695176");
        extraProductVo.setProductId("107901113455346181");
        extraProductVo.setProductName("半糖");
        extraProductVo.setQty(1);
        extraProductVoList.add(extraProductVo);
        shoppingCartProductVo.setExtra(extraProductVoList);
        shoppingCartProductVoList.add(shoppingCartProductVo);
        shoppingCartAddRequestVo.setProducts(shoppingCartProductVoList);
        String str = JSONObject.toJSONString(shoppingCartAddRequestVo);
        try {
            mockMvc.perform(post("/shoppingCart/submit").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 查询购物车信息
     */
    @Test
    public void getDetail() {
        ShoppingCartInfoRequestVo shoppingCartInfoRequestVo = new ShoppingCartInfoRequestVo();
        shoppingCartInfoRequestVo.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        shoppingCartInfoRequestVo.setSessionId("107001391351857666");
        shoppingCartInfoRequestVo.setShopId("1036");
        String str = JSONObject.toJSONString(shoppingCartInfoRequestVo);
        try {
            mockMvc.perform(post("/shoppingCart/info").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 清空购物车
     */
    @Test
    public void clear() {
        ShoppingCartClearRequestVo shoppingCartClearRequestVo = new ShoppingCartClearRequestVo();
        shoppingCartClearRequestVo.setSessionId("107001391351857666");
        shoppingCartClearRequestVo.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        shoppingCartClearRequestVo.setShopId("1036");
        String str = JSONObject.toJSONString(shoppingCartClearRequestVo);
        try {
            mockMvc.perform(post("/shoppingCart/clear").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
