package cn.freemud.manager;

import cn.freemud.adapter.SpellGroupOrderAdapter;
import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.CreateSpellGroupOrderDto;
import cn.freemud.entities.dto.GetProductInfoDto;
import cn.freemud.entities.dto.ProductInfosDto;
import cn.freemud.entities.dto.product.ProductInfo;
import cn.freemud.entities.dto.promotion.CalculationDiscountRequestDto;
import cn.freemud.entities.dto.promotion.CalculationDiscountResponseDto;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.thirdparty.PromotionDiscountClient;
import cn.freemud.service.thirdparty.StoreItemClient;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.membercenter.request.QueryReceiveAddressRequest;
import com.freemud.application.sdk.api.membercenter.response.QueryReceiveAddressResponse;
import com.freemud.application.sdk.api.membercenter.service.MemberCenterService;
import com.freemud.application.sdk.api.storecenter.request.StoreInfoRequest;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.application.sdk.api.storecenter.service.StoreCenterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wanghanghang
 * @title: SpellGroupOrderDataManager
 * @projectName order-group
 * @description: TODO
 * @date 2021/4/15下午3:45
 */
@Component
public class SpellGroupOrderDataManager {

    @Autowired
    private StoreItemClient storeItemClient;

    @Autowired
    private PromotionDiscountClient promotionDiscountClient;

    //会员SDK
    @Autowired
    private MemberCenterService memberCenterService;

    //门店SDK
    @Autowired
    private StoreCenterService storeCenterService;


    /**
     * 查询门店信息
     */
    public StoreResponse getStoreInfo(String partnerId, String shopId, String trackingNo) {
        // 获取门店信息
        StoreInfoRequest storeInfoRequest = new StoreInfoRequest(partnerId, shopId, null);
        StoreResponse storeResponse = storeCenterService.getStoreInfo(storeInfoRequest, trackingNo);
        if (storeResponse == null || storeResponse.getBizVO() == null) {
            throw new ServiceException(ResponseResult.STORE_ITEM_QUERY_ERROR);
        }
        return storeResponse;
    }


    /**
     * 查询地址信息
     *
     * @param receiveId
     * @param partnerId
     * @param trackingNo
     * @return
     */
    public QueryReceiveAddressResponse queryOrderReceiveAddress(String receiveId, String partnerId, String trackingNo) {
        QueryReceiveAddressRequest request = new QueryReceiveAddressRequest(receiveId, partnerId);
        BaseResponse<QueryReceiveAddressResponse> queryReceiveAddressResponse = memberCenterService.queryReceiveAddressById(request, trackingNo);
        if (!ResponseResult.SUCCESS.getCode().equals(queryReceiveAddressResponse.getCode()) || queryReceiveAddressResponse.getData() == null) {
//            throw new ServiceException(ResponseResult.SPELL_GROUP_QUERY_ORDER_RECEIVE_ADDRESS_ERROR);
        }
        QueryReceiveAddressResponse receiveAddressResult = queryReceiveAddressResponse.getData();
        return receiveAddressResult;
    }

    /**
     * 查询商品信息
     *
     * @param createSpellGroupOrderDto
     * @return
     */
    public List<ProductInfo> queryProductInfos(CreateSpellGroupOrderDto createSpellGroupOrderDto) {
        GetProductInfoDto getProductInfoReq = new GetProductInfoDto();
        List<String> proIds = new ArrayList<>();
        createSpellGroupOrderDto.getSpellGroupProductList().forEach(proInfo -> {
            proIds.add(proInfo.getProductId());
        });
        getProductInfoReq.setProductIds(proIds);
        getProductInfoReq.setPartnerId(createSpellGroupOrderDto.getPartnerId());
        getProductInfoReq.setShopId(createSpellGroupOrderDto.getStoreId());
        getProductInfoReq.setProductInfoType(1);
        ProductInfosDto productInfosReps = storeItemClient.listProductInfos(getProductInfoReq);
        if (!ResponseResult.SUCCESS.getCode().equals(productInfosReps.getErrcode().toString()) || productInfosReps.getData() == null) {
            throw new ServiceException(ResponseResult.SPELL_GROUP_QUERY_PRODUCT_INFOS_ERROR);
        }
        return productInfosReps.getData().getProducts();
    }

    /**
     * 查询算价信息
     *
     * @param calculationDiscountRequestDto
     * @return
     */
    public ActivityCalculationDiscountResponseDto queryCalculationDiscount(CalculationDiscountRequestDto calculationDiscountRequestDto) {
        ActivityCalculationDiscountResponseDto activityCalculationDiscountResponseDto = promotionDiscountClient.calculationDiscountSharing(calculationDiscountRequestDto);
        if (!ResponseResult.SUCCESS.getCode().equals(activityCalculationDiscountResponseDto.getStatusCode()) || activityCalculationDiscountResponseDto.getResult() == null) {
            throw new ServiceException(ResponseResult.SPELL_GROUP_QUERY_CALCULATION_DISCOUNT_ERROR);
        }
        return activityCalculationDiscountResponseDto;

    }


}
