package cn.freemud.entities.vo;

import lombok.Builder;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author wanghanghang
 * @title: CreateSpellGroupOrderReq
 * @projectName order-group
 * @description: 创建拼团订单request
 * @date 2021/4/14上午9:52
 */
@Data
public class CreateSpellGroupOrderReq {
    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    /**
     * 参与拼团编号->团编号
     */
    private String spellGroupCode;

    @NotEmpty(message = "门店ID 不能为空")
    private String storeId;

    @NotEmpty(message = "商户号 不能为空")
    private String partnerId;

    @Builder.Default
    private String menuType = "saasmall";

    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType = "saasmall";

    /*下单渠道必填，根据此字段的值判断是自营或第三方，来走不同的状态机 详细见 orderClientType枚举*/
    private Integer orderClient;

    /**
     * 下单支付渠道类型
     */
    @NotNull(message = "下单支付渠道类型不能为空")
    private Byte payChannelType;

    /**
     * 订单类型  1 到店自取 2 外卖   枚举CreateOrderType
     */
    @Builder.Default
    private Integer orderType = 3;

    /**
     * 订单特殊类型 1:普通订单 2:拼团订单 3:秒杀订单 4:拼单订单
     */
    @Builder.Default
    private Integer marketingType = 2;

    /**
     * 收货地址ID
     */
    @NotEmpty(message = "收货地址ID不能为空")
    private String receiveId;

    /**
     * 拼团活动号
     */
    @NotEmpty(message = "拼团活动号不能为空")
    private String activityCode;

    /**
     * 拼团商品集合，本次只会传入一条
     */
    @NotNull(message = "拼团商品信息不能为空")
    private List<SpellGroupProduct> spellGroupProductList;

    /**
     * 订单备注，预留字段
     */
    private String orderRemark;

    /**
     * 城市编号。用于查询配送费
     */
    private String cityCode;

    /**
     * 拼团商品
     */
    @Data
    public static class SpellGroupProduct {
        private String productId;
        private Integer productQuantity;
    }

}
