package cn.freemud.entities.db;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

@Data
@Table(name = "open_platform_partner_merchant_indirect")
public class OpenPlatformPartnerMerchantIndirect {
    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "indirect_id")
    private Long indirectId;

    /**
     * 间联渠道名称
     */
    @Column(name = "platform_name")
    private String platformName;

    /**
     * 间联渠道编号
     */
    @Column(name = "platform")
    private String platform;

    /**
     * 支付商户号
     */
    @Column(name = "mch_id")
    private String mchId;

    /**
     * 商户id
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 公钥
     */
    @Column(name = "public_key")
    private String publicKey;

    /**
     * 私钥
     */
    @Column(name = "private_key")
    private String privateKey;

    /**
     * 签名
     */
    @Column(name = "platform_app_key")
    private String platformAppKey;

    /**
     * 商户主体公司名称
     */
    @Column(name = "company_name")
    private String companyName;

    /**
     * 支付账号（支付服务唯一标识）
     */
    @Column(name = "pay_accountid")
    private Integer payAccountid;

    /**
     * 支付手续费率
     */
    @Column(name = "fee_type")
    private String feeType;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

}
