/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: EnterShopActivityResponseVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/10/12 15:40
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto.activity;

import cn.freemud.entities.vo.PayGiftCouponVo;
import cn.freemud.entities.vo.PayGiftGoodsConfigVo;
import cn.freemud.entities.vo.PayGiftMicroProgramConfigVo;
import cn.freemud.entities.vo.PayGiftWechatCouponInfoVo;
import lombok.Data;

import java.util.List;

@Data
public class PayGiftCheckAndJoinResponseDto {

    /**
     * 活动号
     */
    private  String activityNo;

    private  String activityName;
    /**
     * 发送方式
     * 0-静默发送
     * 5-手动发送
     */
    private  Integer sendType;

    /**
     * 活动类型
     */
    private  String type;
    private List<PayGiftCouponVo> coupons;
    private PayGiftWechatCouponInfoVo wechatCouponInfo;

    /**
     * 奖励类型：1-非码券，2-微信商家券，3-弹窗奖励
     */
    private String syncWechat;

    /**
     * 活动配图
     */
    private String activityPicture;

    /**
     * 跳转设置(跳转类型) 0:无 5:跳转页面 10:外部小程序 15:跳转商品 20:跳转H5
     */
    private String redirectType;

    /**
     * 跳转商品
     */
    private PayGiftGoodsConfigVo goodsConfig;

    /**
     * 跳转小程序
     */
    private PayGiftMicroProgramConfigVo microProgramConfig;

    /**
     * 跳转页面5和20跳转外部H5对应的路径或者URL
     */
    private String redirectPage;
}
