package cn.freemud.entities.dto.activity;

import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/6/23 下午9:24
 * @description :
 */
@Data
public class ActivitysDtoNew {

    /**
     * 活动号
     */
    private String activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动弹窗图片
     */
    private String activityPicture;

    /**
     * 跳转类型:0:无 5:跳转页面 10:外部小程序 15:跳转商品 20:跳转H5
     */
    private String redirectType;

    /**
     * 跳转页面5和20跳转外部H5对应的路径或者URL
     */
    private String redirectPage;

    /**
     * 跳转商品对象
     */
    private GoodsConfig goodsConfig;

    /**
     * 跳转小程序对象
     */
    private MicroProgramConfig microProgramConfig;



    @Data
    @NoArgsConstructor
    static class GoodsConfig {
        /**
         * 跳转商品ID
         */
        private String goodsId;

        /**
         * 跳转商品名称
         */
        private String goodsName;

        /**
         * 跳转商品价格,单位分
         */
        private String price;
    }

    @Data
    @NoArgsConstructor
    static class MicroProgramConfig {
        /**
         * 跳转小程序ID
         */
        private String appId;

        /**
         * 跳转小程序跳转路径
         */
        private String redirectUrl;

    }
}
