package cn.freemud.entities.dto;


import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CouponCodeVerificationTransVO
 * @Package com.freemud.walmart.vo.Finals
 * @Description:
 * @author: biao.zhang
 * @date: 2018/11/19 14:50
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class CouponCodeVerificationTransDto {

    /**
     * 券号
     */
    private String code;
    //private String ebcode;

    /**
     * 实收金额单位：分
     */
    private Integer pay_amount;

    /**
     * 商品信息
     */
    private List<CouponCodeVerificationProductDto> products;

    /**
     * 总优惠金额单位：分
     */
    private Integer totalAmount;

    /**
     * 订单号，coco核销使用
     */
    private String orderNumber;

    /**
     * 应收金额，单位：分，coco核销使用
     */
    private Integer amountRec;

    /**
     * 实收金额，单位：分
     */
    private Integer amountPaid;

}
