package cn.freemud.entities.dto.calculate;

import lombok.Data;

@Data
public class SendGoods {

    /**
     * 买一赠一时，存赠送主商品的cartGoodsUid 用于标记是那个商品送的
     */
    private String originalGoodsUid;

    /**
     * 赠送商品ID
     */
    private String goodsId;
    /**
     * 品类
     */
    private String category;
    /**
     * 赠送商品名称
     */
    private String goodsName;
    /**
     * 赠送商品现价（单位：分）（加价换购时表示需要加的价格）
     */
    private Long nowPrice;
    /**
     * 赠送商品原价
     */
    private Long originalPrice;
    /**
     * 赠送商品数量
     */
    private Integer sendNumber;

    /**
     *  可兑换商品券编号
     */
    private String sendCouponCode;

    /**
     *  可兑换商品券名称
     */
    private String sendCouponName;

    /**
     *  是否已选择寄杯
     */
    private Boolean sendCoupon;

    private String picture;

    /**
     * 1.9.2商品套餐新增商品类型 后续C端小程序使用该字段获取商品类型
     * 1:单品无属性
     * 2:单品有属性
     * 7:套餐
     * 8:多规格有属性
     * 10:多规格无属性
     */
    private Integer productType;

}
