package cn.freemud.demo.adapter.manager;

import cn.freemud.demo.entities.bo.goods.ValidateShopProductRequestBO;
import cn.freemud.demo.entities.bo.product.GetProductStock;
import cn.freemud.demo.entities.bo.product.GetRequiredProductListBO;
import cn.freemud.entities.dto.GetProductStockRequestDto;
import cn.freemud.entities.dto.RequiredProductRequest;
import cn.freemud.entities.dto.product.ValidateShopProductRequest;
import cn.freemud.utils.BeanUtil;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class ProductBO2DTOAdapter {

    @Resource
    private MapperFacade mapperFacade;


    public GetProductStockRequestDto convert2GetProductStockDto(GetProductStock getProductStock) {
        GetProductStockRequestDto getProductStockRequestDto = new GetProductStockRequestDto();
        getProductStockRequestDto.setChannel(getProductStock.getChannel());
        getProductStockRequestDto.setPartnerId(getProductStock.getPartnerId());
        getProductStockRequestDto.setProductIds(getProductStock.getProductIds());
        getProductStockRequestDto.setStoreId(getProductStock.getStoreId());

        return getProductStockRequestDto;
    }

    public ValidateShopProductRequest convert2ValidateShopProductRequest(ValidateShopProductRequestBO validateShopProductRequestBO) {

        ValidateShopProductRequest validateShopProductRequest = BeanUtil.convertBean(validateShopProductRequestBO, ValidateShopProductRequest::new);

        return validateShopProductRequest;
    }

    public RequiredProductRequest convert2RequiredProductRequest(GetRequiredProductListBO getRequiredProductListBO) {

        RequiredProductRequest requiredProductRequest = BeanUtil.convertBean(getRequiredProductListBO, RequiredProductRequest::new);

        return requiredProductRequest;
    }

}
