package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import com.freemud.sdk.api.assortment.order.enums.OldOrderAccountType;
import lombok.Data;

import java.util.List;

@Data
public class ConfirmOrderRequest extends BaseConfig {

    private String partnerId;
    private String storeId;
    /**
     * 普通订单：普通订单单号
     * 会员卡父子订单：父订单号
     */
    private String orderId;
    //老订单状态
    private Integer orderType;

    private String payChannelName;

    private String payVoucher;

    /**
     * 订单类型为会员卡父子订单时，此字段赋值且为会员卡订单号
     */
    private String completeOrderCode;
    /**
     * 商品订单单号
     * 订单类型为普通订单时，此字段赋值且为普通订单订单号
     * 订单类型为会员卡父子订单时，此字段赋值且为普通订单订单号
     */
    private String productOrderCode;

    private Integer timeout;
    //实际支付金额
    private String actualPayAmount;
    /**
     * 自定义字段
     */
    private String extInfo;
    //操作人
    private String operator;
    /**
     * 订单支付时间
     */
    private String payDate;
    /**
     * 第三方流水号
     */
    private String payTransId;
    private List<OrderSettlement>orderSettlements;

    //用户预约时间，仅为预约单时存放
    private String expectTime;

    @Data
    public static class OrderSettlement{
        /**
         * 优惠结算类型
         */
        private OldOrderAccountType settlementType;

        /**
         * 平台优惠
         */
        private Long platformDiscountAmount;

        /**
         * 商家优惠
         */
        private Long shopDiscountAmount;
        /**
         * 结算金额
         */
        private Long settlementAmount;
        /**
         * 备注
         */
        private String note;

    }
}
