package cn.freemud.service.job;

import com.alibaba.druid.pool.DruidDataSource;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author: liubing.
 * @date: 2021/6/15 15:37
 */
@Component
public class PrometheusSchedulerCustomJob {

    /**
     * mq当前空闲(缓存)的事务通道的数量。
     * mq当前空闲(高速缓存)的非事务性通道的数量。
     * mq同时空闲(缓存)的事务通道的最大数量。
     * mq非事务性通道的最大数量同时处于空闲状态(缓存)。
     */
    private final AtomicInteger idleChannelsNotTxGauge, idleChannelsTxGauge, idleChannelsTxHighWaterGauge, idleChannelsNotTxHighWaterGauge;

    /**
     * 当前连接数
     * 最大连接池数量
     * 最大连接池数量
     * 最小连接池数量
     */
    private final AtomicInteger activeCountGauge, maxActiveGauge, maxIdleGauge, minIdleGauge,poolingCountGauge;

    private final CachingConnectionFactory cachingConnectionFactory;
    private final DruidDataSource druidDataSource;


    public PrometheusSchedulerCustomJob(MeterRegistry meterRegistry, CachingConnectionFactory cachingConnectionFactory, DruidDataSource druidDataSource) {
        this.cachingConnectionFactory = cachingConnectionFactory;
        this.druidDataSource = druidDataSource;
        idleChannelsNotTxGauge = meterRegistry.gauge("rabbitmq_idle_channels_not_tx", new AtomicInteger(0));
        idleChannelsTxGauge = meterRegistry.gauge("rabbitmq_idle_channels_tx", new AtomicInteger(0));
        idleChannelsTxHighWaterGauge = meterRegistry.gauge("rabbitmq_idle_channels_tx_high_water", new AtomicInteger(0));
        idleChannelsNotTxHighWaterGauge = meterRegistry.gauge("rabbitmq_idle_channels_not_tx_high_water", new AtomicInteger(0));

        activeCountGauge = meterRegistry.gauge("db_active_count", new AtomicInteger(0));
        poolingCountGauge = meterRegistry.gauge("db_pooling_count",new AtomicInteger(0));
        maxActiveGauge = meterRegistry.gauge("db_max_active", new AtomicInteger(0));
        maxIdleGauge = meterRegistry.gauge("db_max_idle", new AtomicInteger(0));
        minIdleGauge = meterRegistry.gauge("db_min_idle", new AtomicInteger(0));

    }

    @Scheduled(fixedRateString = "15000", initialDelayString = "0")
    public void schedulingTask() {
        Properties cacheProperties = cachingConnectionFactory.getCacheProperties();

        idleChannelsNotTxGauge.set(Integer.parseInt(cacheProperties.getOrDefault("idleChannelsNotTx", 0).toString()));
        idleChannelsTxGauge.set(Integer.parseInt(cacheProperties.getOrDefault("idleChannelsTx", 0).toString()));
        idleChannelsTxHighWaterGauge.set(Integer.parseInt(cacheProperties.getOrDefault("idleChannelsTxHighWater", 0).toString()));
        idleChannelsNotTxHighWaterGauge.set(Integer.parseInt(cacheProperties.getOrDefault("idleChannelsNotTxHighWater", 0).toString()));

        activeCountGauge.set(druidDataSource.getActiveCount());
        poolingCountGauge.set(druidDataSource.getPoolingCount());
        maxActiveGauge.set(druidDataSource.getMaxActive());
        maxIdleGauge.set(druidDataSource.getMaxIdle());
        minIdleGauge.set(druidDataSource.getMinIdle());
    }
}
