package cn.freemud.service.thirdparty;

import cn.freemud.entities.vo.order.EditLogisticsReq;
import cn.freemud.entities.vo.order.DirectDeliveryReq;
import cn.freemud.entities.vo.order.QueryByKeysReq;
import cn.freemud.entities.vo.order.QueryByKeysResp;
import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.QueryInvoiceRepDto;
import cn.freemud.entities.dto.QueryRefundFailuresListDto;
import cn.freemud.entities.dto.order.QueryInvoiceByCodesResponse;
import cn.freemud.entities.dto.order.RefundFailureRequestDTO;
import cn.freemud.entities.dto.pay.OrderInvoiceRequest;
import cn.freemud.entities.dto.pay.QueryInvoiceByCodesRequest;
import cn.freemud.entities.vo.QueryInvoiceReq;
import cn.freemud.entities.vo.QueryRefundFailuresListReq;
import cn.freemud.entities.vo.RefundFailuresSuccessfulReq;
import com.freemud.sdk.api.assortment.order.request.order.V2CancelOrderRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

@FeignClient(name = "order-service",url = "${order.service.url:}")
@RequestMapping(consumes = MediaType.APPLICATION_JSON_UTF8_VALUE, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public interface OrderServiceClient {
    /**
     * 创建订单开票记录
     */
    @LogIgnoreFeign(logMessage="createInvoice")
    @PostMapping("/order/v2/invoice/create")
    BaseResponse createInvoice(@RequestBody OrderInvoiceRequest orderCounts);

    /**
     * 查询用户订单号是否已开票
     */
    @LogIgnoreFeign(logMessage="queryInvoiceByCodes")
    @PostMapping("/order/v2/invoice/queryByCodes")
    BaseResponse<QueryInvoiceByCodesResponse> queryInvoiceByCodes(@RequestBody QueryInvoiceByCodesRequest request);

    /**
     * 2021年9月15日-开票历史列表接口+详情接口+发票所含订单接口-黄兆良
     * 开票历史列表接口
     */
    @LogIgnoreFeign(logMessage="queryInvoiceList")
    @PostMapping(value = "/order/v2/invoice/list/forUser")
    QueryInvoiceRepDto queryInvoiceList(@RequestBody QueryInvoiceReq queryInvoiceReq);

    /**
     * 虚拟券退款操作失败记录,用于后期补偿
     */
    @LogIgnoreFeign(logMessage="refundFailures")
    @PostMapping("/order/v2/refundFailures")
    BaseResponse refundFailures(@RequestBody RefundFailureRequestDTO requestDTO);

    /**
     * 退款失败信息列表查询
     */
    @LogIgnoreFeign(logMessage="refundFailuresList")
    @PostMapping(value = "/order/v2/refundFailures/list")
    BaseResponse<List<QueryRefundFailuresListDto>> refundFailuresList(@RequestBody QueryRefundFailuresListReq queryRefundFailuresListReq);

    /**
     * 退款失败信息列表查询
     */
    @LogIgnoreFeign(logMessage="refundFailuresSuccessful")
    @PostMapping(value = "/order/v2/refundFailures/successful")
    BaseResponse refundFailuresSuccessful(@RequestBody RefundFailuresSuccessfulReq refundFailuresSuccessfulReq);

    /**
     * 订单物流推送订单
     */
    @LogIgnoreFeign(logMessage="editLogistics")
    @PostMapping(value = "/order/v2/editLogistics")
    BaseResponse editLogistics(@RequestBody EditLogisticsReq editLogisticsReq);

    /**
     * 订单发货
     */
    @LogIgnoreFeign(logMessage="directDelivery")
    @PostMapping(value = "/order/v2/directDelivery")
    BaseResponse directDelivery(@RequestBody DirectDeliveryReq DeditLogisticsReq);

    /**
     * 查询待支付订单时效配置
     */
    @LogIgnoreFeign(logMessage="queryByKeys")
    @PostMapping(value = "/order/config/queryByKeys")
    BaseResponse<List<QueryByKeysResp>> queryByKeys(@RequestBody QueryByKeysReq req);


    @LogIgnoreFeign(logMessage="createInvoice")
    @PostMapping("/order/v2/cancelPortion")
    BaseResponse<Void> refundOrder(@RequestBody V2CancelOrderRequest v2CancelOrderRequest);
}
