package cn.freemud.manager;

import cn.freemud.entities.db.OpenPlatformOrderConfig;
import cn.freemud.entities.vo.order.GetOrderConfigRequestVo;
import cn.freemud.manager.dao.OpenPlatformOrderConfigDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @description:
 * @author: chengfeixiang<feixiang.cheng @ freemud.cn>
 * @date: 2022/1/25 15:15
 * @version: v1.0
 * @copyright: 2022 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Component
public class OpenPlatformOrderConfigManager {

    @Autowired
    private OpenPlatformOrderConfigDao orderConfigDao;


    public OpenPlatformOrderConfig getOrderConfigByType(GetOrderConfigRequestVo request) {
        OpenPlatformOrderConfig config = new OpenPlatformOrderConfig();
        config.setPartnerId(request.getPartnerId());
        config.setMinAppId(request.getMiniAppId());
        config.setType(request.getType());
        /** 0 关闭 1开启 */
        config.setState(1);
        List<OpenPlatformOrderConfig> configs = orderConfigDao.select(config);
        return CollectionUtils.isEmpty(configs) ? null : configs.get(0);
    }
}
