package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.OrderDevelopRefundVo;
import cn.freemud.service.RefundService;
import cn.freemud.utils.ResponseUtil;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/4/30 14:55
 * @description : 针对开发人员开放的接口操作, 不暴露给外部人员
 */
@RequestMapping("/order/develop")
@RestController
public class OrderDeveloperController {

    @Autowired
    private RefundService refundService;

    /**
     * 订单内部人员操作 给订单退款, 使用该接口需要报备
     * 1.生成售后单
     * 2.直接调用oms进行退款处理
     */
    @ApiAnnotation(logMessage = "/order/develop/refund")
    @PostMapping("/refund")
    public BaseResponse<Map<String, String>> developRefund(@Validated @LogParams @RequestBody OrderDevelopRefundVo orderRefundVo) {
        return ResponseUtil.success(refundService.batchDevelopRefund(orderRefundVo));
    }

}
