package cn.freemud.adapter;

import cn.freemud.entities.dto.ConfirmOrderDto;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.sdk.api.assortment.order.enums.OldOrderAccountType;
import com.freemud.sdk.api.assortment.order.request.order.ConfirmOrderRequest;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: ${TODO}(用一句话描述该文件做什么)
 * @author: aiqi.gong
 * @date: 2019/5/19 16:20
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public class LightApplicationConvertToAssortmentSdkAdapter {
   public static ConfirmOrderRequest confirmOrderDtoConvertToConfirmOrderRequest(ConfirmOrderDto confirmOrderDto, OrderBeanV1 memberOrder){
       ConfirmOrderRequest var1 = new ConfirmOrderRequest();
       var1.setOrderId(confirmOrderDto.getOrderId());
       var1.setPayVoucher(confirmOrderDto.getPayVoucher());
       var1.setTrackingNo(LogThreadLocal.getTrackingNo());
       if (memberOrder!=null){
           //会员卡设置直接完成的订单
           var1.setCompleteOrderCode(memberOrder.getOid());
       }
       Integer totalAmount=confirmOrderDto.getOrderSettlementAmount();
       if ((confirmOrderDto.getPlatformCoupon()!=null&&confirmOrderDto.getPlatformCoupon()>0)||(confirmOrderDto.getMerchantCoupon()!=null&&confirmOrderDto.getMerchantCoupon()>0)){
           List<ConfirmOrderRequest.OrderSettlement> orderSettlements=new ArrayList<>();
           ConfirmOrderRequest.OrderSettlement orderSettlement=new ConfirmOrderRequest.OrderSettlement();
           if (confirmOrderDto.getMerchantCoupon()!=null){
               orderSettlement.setShopDiscountAmount(confirmOrderDto.getMerchantCoupon().longValue());
               orderSettlement.setSettlementAmount(confirmOrderDto.getMerchantCoupon().longValue());
               totalAmount-=confirmOrderDto.getMerchantCoupon();
           }
           if (confirmOrderDto.getPlatformCoupon()!=null){
               orderSettlement.setPlatformDiscountAmount(confirmOrderDto.getPlatformCoupon().longValue());
               orderSettlement.setNote("微信优惠");
               totalAmount-=confirmOrderDto.getMerchantCoupon();
           }
           orderSettlement.setSettlementType(OldOrderAccountType.WEIXIN);
           orderSettlements.add(orderSettlement);
           var1.setOrderSettlements(orderSettlements);
       }
       var1.setActualPayAmount(totalAmount.toString());
       return var1;
   }
}
