package cn.freemud.adapter;

import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.enums.AfterSalesType;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.sdk.api.assortment.order.enums.AfterSalesRefunStateEnum;
import com.freemud.sdk.api.assortment.order.enums.OperationClientEnum;
import com.freemud.sdk.api.assortment.order.request.order.CancelOrderRequest;
import org.apache.commons.lang.StringUtils;

/**
 * @author Clover.z
 * @version 1.0.0
 * @since 1.0.0
 */
public class CancelOrderRequestAdapter {

    public static CancelOrderRequest convert(OrderInfoReqs order, String refundId, AfterSalesType afterSalesType, String reason, String remark, Boolean refundDeliveryFee, Byte refundMode) {
        CancelOrderRequest req = new CancelOrderRequest();
        req.setOrderId(order.getOrderCode());
        req.setPartnerId(order.getPartnerId());
        req.setAfterSalesType(afterSalesType);
        req.setOrderClient(order.getOrderClient());
        if (StringUtils.isNotBlank(reason) && reason.length() > 50) {
            reason = reason.substring(0, 50);
        }
        req.setReason(reason);
        req.setTrackingNo(LogThreadLocal.getTrackingNo());
        req.setRefundSerialNo(refundId);
        //操作来源客户端 1:POS插件 2:小助手 3:开放平台 4:自动任务 5:用户端 6:系统 7:万象 8:太一
        req.setOperationClient(OperationClientEnum.STATE_5.getIndex());
        req.setOperator(order.getUserName());
        if (AfterSalesType.SYSTEM_CANCEL.getIndex().equals(afterSalesType.getIndex())) {
            req.setOperator("admin");
            req.setOperationClient(OperationClientEnum.STATE_6.getIndex());
        }
        // 这里给默认值,外面调用者 自己的根据业务判断退款 状态
        req.setRefundState(AfterSalesRefunStateEnum.STATE_1.getIndex());
        req.setReqRemark(remark);
        req.setRefundDeliveryAmount(refundDeliveryFee);
        // 商城订单 增加拓展信息
        CancelOrderRequest.AfterSalesOrderExtInfoReq ext = new CancelOrderRequest.AfterSalesOrderExtInfoReq();
        ext.setRefundMode(refundMode);
        req.setExtInfoReq(ext);
        return req;
    }
}
