package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.application.sdk.api.ordercenter.request.create.OrderTaskReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Data
public class V2CancelOrderRequest {
    @ApiModelProperty(value = "商户号", required = true)
    @NotNull
    private String partnerId;

    @ApiModelProperty(value = "操作人")
    private String operator;

    @ApiModelProperty(value = "订单编号，与thirdOrderCode二选一，如果orderCode为null则使用thirdOrderCode查询订单")
    private String orderCode;

    @ApiModelProperty(value = "第三方订单编码，与orderCode二选一，三平台订单号,例如百度、饿了么、美团")
    private String thirdOrderCode;

    @NotNull(message = "下单渠道不能为空")
    @Range(min = 1, max = 127)
    private Byte orderClient;

    @ApiModelProperty(value = "退的配送费，单位：分")
    private BigDecimal deliveryAmount;

    @ApiModelProperty(value = "售后原因")
    private String afterSalesReason;

    @ApiModelProperty(value = "取消原因", hidden = true)
    private String cancelReason;

    @ApiModelProperty(value = "申请说明")
    private String reqRemark = "";

    @ApiModelProperty(value = "从创建售后单开始计时，超时完成的时间（单位：分钟），超时后通知。若不需要通知，则不填写。")
    private Integer timeout;

    @ApiModelProperty(value = "订单定时任务")
    private OrderTaskReq orderTask;

    /**
     * 操作来源客户端
     */
    @ApiModelProperty(value = "操作来源客户端 1:POS插件 2:小助手 3:开放平台 4:自动任务 5:用户端 6:系统 7:万象 8:太一")
    private Byte operationClient;

    /**
     * 售后退款状态
     */
    @ApiModelProperty(value = "售后退款状态 0:未定义（存量数据） 1:未退款 2:退款中 3:退款失败 4:已退款")
    private Byte refundState;

    /**
     * 退款失败原因
     */
    @ApiModelProperty(value = "退款失败原因")
    private String refundFailReason;

    @ApiModelProperty(value = "售后单类型", required = true)
    @NotNull
    private Byte afterSalesType;

    @ApiModelProperty(value = "是否退配送费，默认值：是")
    @Builder.Default
    private boolean isRefundDeliveryAmount = true ;

    @ApiModelProperty(value = "申请金额，单位分，如果是全部退款，并且传递null,则自动填入 订单用户需支付金额", required = true)
    private BigDecimal reqAmount;

    @ApiModelProperty(value = "若为null，默认只做【创建】，售后单状态为【待处理】\n" +
            "若为2，默认做【创建】+【审核通过】，售后单状态为【退货中】\n" +
            "若为5，默认做【创建】+【同意并退货完成】，售后单状态【已退货】\n" +
            "若为4，默认做【创建】+【同意并退款完成】，售后单状态为【完成】")
    private Byte createEvent;

    @ApiModelProperty(value = "扩展字段")
    private String extInfo = "{}";

    @ApiModelProperty(value = "订单是否需要挂起,默认挂起")
    private boolean suspended = true;

}
