/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderCancelReq
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/2 21:26
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.application.sdk.api.ordercenter.enums.AfterSalesType;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
public class CancelOrderRequest extends BaseConfig {


    private String partnerId;

    private String storeId;

    private AfterSalesType afterSalesType;
    /**
     * 订单ID
     */
    private String orderId;
    /**
     * 原因
     */
    private String reason;
    /**
     * 用户申请退款描述
     */
    private String reqRemark;

    /**
     * 售后单code,新订单服务需要
     */
    private String afterSalesCode;
    /**
     * 非码流水ID
     */
    private String fmId;
    /**
     * 退款流水号
     */
    private String refundSerialNo;
    /**
     *  若为null，默认只做【创建】，售后单状态为【待处理】
        若为2，默认做【创建】+【审核通过】，售后单状态为【退货中】
        若为5，默认做【创建】+【同意并退货完成】，售后单状态【已退货】
        若为4，默认做【创建】+【同意并退款完成】，售后单状态为【完成】
     *  cn.freemud.enums.AfterSalesOrderCreateEventEnum
     */
    private Integer createEvent;

    private Integer orderClient= OrderClientType.SAAS.getIndex();

    //操作人
    private String operator;

    /**
     * 是否退配送费
     */
    @Builder.Default
    private boolean isRefundDeliveryAmount = true;

    //用户预约时间，仅为预约单时存放
    private String expectTime;

    private Integer statusV2;

    /**
     * 操作来源客户端 1:POS插件 2:小助手 3:开放平台 4:自动任务 5:用户端 6:系统 7:万象 8:太一
     */
    private Integer operationClient;

    /**
     * 售后退款状态 0:未定义（存量数据） 1:未退款 2:退款中 3:退款失败 4:已退款
     */
    private Integer refundState;

    /**
     * 售后单拓展信息
     */
    private AfterSalesOrderExtInfoReq extInfoReq;

    /**
     * 售后单拓展信息
     */
    @NoArgsConstructor
    @Data
    public static class AfterSalesOrderExtInfoReq {

        /**
         * 微商城退款方式
         */
        private Byte refundMode;
        /**
         * 拼团订单批量退款批次号
         */
        private Long batchRefundId;
    }
}
