package cn.freemud.management.entities.dto.response.coupon;

import lombok.Data;

import java.util.List;

/**
 * 麦当劳.net券详情响应对象
 * <p>
 * 此对象和.net接口保持一致
 *
 * @author Tony
 */
@Data
public class McdNetCouponInfoRespDto {

    /**
     * 活动编号
     */
    private String act_id;

    /**
     * 活动名称
     */
    private String act_name;
    /**
     * 活动描述
     */
    private String act_desc;
    /**
     * 优惠券过期时间
     */
    private String vdata;

    /**
     * 优惠券编号
     */
    private String code;

    private String start_time;
    private String end_time;

    /**
     * 优惠券渠道商编号
     */
    private String ebcode;

    /**
     * 优惠券渠道商名称
     */
    private String ebname;

    /**
     * 最低消费金额，单位是分，代金券或者折扣券返回、
     * 满减券满的金额；
     * 满免券满的金额；
     */
    private Integer minamount;

    /**
     * 代金券金额，单位是分
     * 只有代金券时返回；
     * 满减券减的金额；
     */
    private Integer amount;

    /**
     * 满免券最低消费的商品数量
     */
    private Integer min_product_amount;

    /**
     * 折扣编码
     */
    private String promotion_type;

    /**
     * 平台编码
     */
    private String platformitemid;

    /**
     * 可用次数
     */
    private Integer availableTimes;

    /**
     * 当天可用次数
     */
    private Integer limitTimes;

    /**
     * 折扣券折扣百分比，7.5折 = 75
     */
    private Integer percent_discount;

    /**
     * 券状态
     */
    private Integer status;

    private Integer extend_type;

    /**
     * 商品组信息
     */
    private List<McdNetCouponProductGroupRespDto> groups;
    /**
     * 只有商品券时返回
     */
    private List<McdNetCouponProductRespDto> products;

}
