/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: QueryOrderResponse
 * @Package cn.freemud.entities.dto
 * @Description: 订单列表
 * @author: liming.guo
 * @date: 2018/5/24 17:37
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderCostResp;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.List;

@NoArgsConstructor
@Data
public class QueryOrdersResponseDto {
    /**
     * data : {"count":3,"orders":[{"accountList":[],"address":"上海市长宁区","amount":1100,"barCounter":"","cancelReason":"","companyId":"360bb48b-5316-458a-903e-9a44c7f339b1","courierName":"","courierPhone":"","createUser":"","customerOrder":"","evaluateStatus":1,"gmtAccept":null,"gmtCreate":1527146094203,"gmtExpect":null,"gmtModified":1527146094203,"gmtPay":1527150816285,"hasRefund":false,"invoiceInfo":"","latitude":32.1232,"longitude":121.23434,"oid":"109457845547698183","orderType":0,"otherCode":"2","partition":"","payChannel":"","payChannelName":"sdf43242","payStatus":2,"payType":1,"payVoucher":"234234","phone":"15170031433","posId":"","productList":[{"customerCode":"","number":1,"opid":"0","orderId":"109457845547698183","parentProduct":"","picture":"","price":1100,"productId":"product1","productName":"奶茶","sequence":10,"specification":"中杯+常温","specificationName":"","unit":""},{"customerCode":"","number":1,"opid":"0","orderId":"109457845547698183","parentProduct":"product1","picture":"","price":0,"productId":"product2","productName":"椰果","sequence":20,"specification":"加糖","specificationName":"","unit":""}],"refundList":[],"remark":"","shopId":"0012","shopName":"上海长宁区旗舰店","source":"","sourceName":"","status":1,"takeAddress":"","type":4,"userId":"m12321332423","userName":"张三","userType":""},{"accountList":[],"address":"上海市长宁区","amount":1100,"barCounter":"","cancelReason":"","companyId":"360bb48b-5316-458a-903e-9a44c7f339b1","courierName":"","courierPhone":"","createUser":"","customerOrder":"","evaluateStatus":1,"gmtAccept":null,"gmtCreate":1527144957247,"gmtExpect":null,"gmtModified":1527144957247,"gmtPay":null,"hasRefund":false,"invoiceInfo":"","latitude":32.332243,"longitude":123.23423,"oid":"109456653362923524","orderType":0,"otherCode":"","partition":"","payChannel":"","payChannelName":"","payStatus":1,"payType":1,"payVoucher":"","phone":"15170031433","posId":"","productList":[{"customerCode":"","number":1,"opid":"0","orderId":"109456653362923524","parentProduct":"","picture":"","price":1100,"productId":"product1","productName":"奶茶","sequence":10,"specification":"中杯+常温","specificationName":"","unit":""},{"customerCode":"","number":1,"opid":"0","orderId":"109456653362923524","parentProduct":"product1","picture":"","price":0,"productId":"product2","productName":"椰果","sequence":20,"specification":"加糖","specificationName":"","unit":""}],"refundList":[],"remark":"","shopId":"0012","shopName":"上海长宁区旗舰店","source":"","sourceName":"","status":2,"takeAddress":"","type":4,"userId":"m12321332423","userName":"张三","userType":""},{"accountList":[],"address":"上海市长宁区","amount":1100,"barCounter":"","cancelReason":"","companyId":"360bb48b-5316-458a-903e-9a44c7f339b1","courierName":"","courierPhone":"","createUser":"","customerOrder":"","evaluateStatus":1,"gmtAccept":null,"gmtCreate":1527144878384,"gmtExpect":null,"gmtModified":1527144878384,"gmtPay":null,"hasRefund":false,"invoiceInfo":"","latitude":32.1232,"longitude":121.23434,"oid":"109456570669074433","orderType":0,"otherCode":"","partition":"","payChannel":"","payChannelName":"","payStatus":1,"payType":1,"payVoucher":"","phone":"15170031433","posId":"","productList":[{"customerCode":"","number":1,"opid":"0","orderId":"109456570669074433","parentProduct":"","picture":"","price":1100,"productId":"product1","productName":"奶茶","sequence":10,"specification":"中杯+常温","specificationName":"","unit":""},{"customerCode":"","number":1,"opid":"0","orderId":"109456570669074433","parentProduct":"product1","picture":"","price":0,"productId":"product2","productName":"椰果","sequence":20,"specification":"加糖","specificationName":"","unit":""}],"refundList":[],"remark":"","shopId":"0012","shopName":"上海长宁区旗舰店","source":"","sourceName":"","status":2,"takeAddress":"","type":4,"userId":"m12321332423","userName":"张三","userType":""}]}
     * errcode : 100
     * errmsg : 查询订单成功
     */

    private DataBean data;
    private int errcode;
    private String errmsg;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }


    @NoArgsConstructor
    @Data
    public static class DataBean {

        private int count;
        private List<OrderBean> orders;


        @NoArgsConstructor
        @Data
        public static class OrderBean {
            private Integer bizType;

            private boolean isParent;

            private String parentCode;
            /**
             * 门店地址
             */
            private String shopAddress;
            /**
             * 收货地址
             */
            private String address;
            /**
             * 门店电话
             */
            private String shopPhone;

            /**
             * 总金额
             */
            private Long amount;
            /**
             * 吧台桌号
             */
            private String barCounter;
            /**
             * 取消原因
             */
            private String cancelReason;
            /**
             * 商户ID
             */
            private String companyId;
            private String courierName;
            private String courierPhone;
            private String createUser;
            private String customerOrder;
            private int evaluateStatus;
            private Object gmtAccept;
            /**
             * 自定义描述字段
             */
            private String extInfo;
            /**
             * 创建时间 时间戳
             */
            private Long gmtCreate;
            /**
             * 期望送达时间
             */
            private Long gmtExpect;
            /**
             * 更新时间 时间戳
             */
            private Long gmtModified;
            private Long gmtPay;
            /**
             * 是否有退款记录
             */
            private Boolean hasRefund;
            private String invoiceInfo;
            /**
             * 维度
             */
            private Double latitude;
            /**
             * 经度
             */
            private Double longitude;
            /**
             * 订单ID
             */
            private String oid;
            /**
             * 下游订单号
             */
            private String downstreamThirdOrderCode;
            /**
             * 订单类型   1 外卖 2 预订单 3 商城 4 打包带走 5 店内就餐
             */
            private Integer orderType;
            /**
             * 取餐码
             */
            private String otherCode;
            private String partition;
            private String payChannel;
            private String payChannelName;
            /**
             * 订单支付状态   1 未支付 2 已支付 3 已退款 4 已经部分退款 5 完成
             */
            private Integer payStatus;
            /**
             * 订单支付类型   1 线上支付 2 货到付款
             */
            private Integer payType;
            /**
             * 支付凭证 非码流水ID
             */
            private String payVoucher;
            /**
             * 手机号
             */
            private String phone;
            private String posId;
            private String remark;
            /**
             * 日订单序号
             */
            private Integer daySeq;
            private String shopId;
            private String shopName;
            private String source;
            private String sourceName;
            /**
             * 订单状态  1 下单 2 待支付 3已接单 4 配送中 5 已完成 6 已取消 7 已拒单 31 制作完成
             */
            private Integer status;
            /**
             * 取餐地址
             */
            private String takeAddress;
            /**
             *  取餐排队号  订单详情使用 默认为空
             */
            private String queueIndex;
            /**
             * 订单类型   1 外卖 2 预订单 3 商城 4 打包带走 5 店内就餐
             */
            private Integer type;
            /**
             * 用户ID
             */
            private String userId;
            /**
             * 用户名称
             */
            private String userName;
            private String userType;
            private List<AccountBean> accountList;
            private List<ProductBean> productList;
            private List<RefundBean> refundList;

            private AddDeliveryInfo addInfo;

            private List<OrderCostResp> orderCostDetailList;

            /**
             * 订单操作状态(从订单操作历史表中获取)
             */
            private String operateTakeOrderTime;
            private String operateWaitPayTime;
            private String operateReceiptTime;
            private String operateDistributionTime;
            private String operateCompleteTime;
            private String operateCalcelTime;
            private String operatePefuseTime;
            private String operateCompleteMakeTime;

            /**
             * 运单状态
             */
            private Integer deliverStatus;

            /**
             * 骑手姓名
             */
            private String riderName;
            /**
             *  骑手文案 商家自配送文案
             */
            private String riderText;
            /**
             * 骑手头像 如果是自配送，显示门店首图
             */
            private String riderPhoto;
            /**
             * 门店首图 扩展字段
             */
            private String shopImageUrl;
            /**
             * 骑手电话
             */
            private String riderPhone;
            /**
             * 系统接单时间
             */
            private String receiveTime;
            /**
             * 骑手分配时间
             */
            private String depatchTime;
            /**
             * 到店时间
             */
            private String arriveShopTime;
            /**
             * 送出时间
             */
            private String sendTime;
            /**
             * 完成时间
             */
            private String completeTime;

            /**
             * 收件人省份
             */
            private String receiveProvince;

            /**
             * 收件人城市
             */
            private String receiveCity;

            /**
             * 收件人区
             */
            private String receiveRegion;

            /**
             * 订单重量
             */
            private BigDecimal weight;

            @NoArgsConstructor
            @Data
            public static class AddDeliveryInfo {
                /**
                 * 外卖中台运单号
                 */
                private String deliveryId;
                /**
                 * 配送公司
                 */
                private String express;
                /**
                 * 配送公司编号
                 */
                private String expressNo;
                //配送类型，self=自配送 thrid=第三方配送
                private String deliveryType;
            }
            @NoArgsConstructor
            @Data
            public static class ProductBean {
                /**
                 * customerCode :
                 * number : 1
                 * opid : 0
                 * orderId : 109457845547698183
                 * parentProduct :
                 * picture :
                 * price : 1100
                 * productId : product1
                 * productName : 奶茶
                 * sequence : 10
                 * specification : 中杯+常温
                 * specificationName :
                 * unit :
                 */

                private String customerCode;
                /**
                 * 商品数量
                 */
                private int number;
                private String opid;
                /**
                 * 订单ID
                 */
                private String orderId;
                /**
                 * 商品ID
                 */
                private String productId;
                /**
                 * 父类商品ID
                 */
                private String parentProductId;
                /**
                 * 商品图片
                 */
                private String picture;
                /**
                 * 商品价格
                 */
                private Long price;
                /**
                 * 商品实际销售价格 扣除优惠价格后计算salePrice V1.5.2增加
                 */
                private Long salePrice;
                /**
                 * 商品名称
                 */
                private String productName;
                /**
                 * 商品排序
                 */
                private int sequence;
                /**
                 * 商品描述
                 */
                private String specification;
                private String specificationName;
                private String unit;
                /**
                 * 商品扩展字段 保存为
                 */
                private String addInfo;

                private String extInfo;

                /**
                 * 套餐--type:6
                 */
                private Integer productType;

                /**
                 * 当前商品的实际优惠信息
                 */
                public List<ProductDiscount> discountList;

                List<ProductBean> comboProduct;

                List<ProductBean> materialProduct;

                @NoArgsConstructor
                @Data
                public static class ProductDiscount {
                    /**
                     * 存放活动ID ，couponCode
                     */
                    private String discountId;
                    /**
                     * 存放活动名称，券名称
                     */
                    private String discountDesc;
                    /**
                     * 存放活动类型 OrderAccountType 枚举
                     */
                    private Integer discountType;
                    /**
                     * 特价
                     */
                    private Long discountPrice;
                    /**
                     * 享受特价数量
                     */
                    private Integer discountQty;
                    /**
                     * 优惠金额 正数
                     */
                    private Long discountAmount;
                    /**
                     * 活动子code
                     */
                    private String customerCode;
                    /**
                     * 活动自定义信息
                     */
                    private String addInfo;

                    private String productId;
                }

            }

            @NoArgsConstructor
            @Data
            public static class RefundBean {

                /**
                 * 订单ID
                 */
                private String orderId;

                /**
                 * 退款价格
                 */
                private Long price;

                /**
                 * 原因
                 */
                private String reason;

                /**
                 * 退款订单
                 */
                private String rid;

                /**
                 * 退款状态  1 申请退款 2 同意退款 3 已退货 4 退款完成 5 拒绝退款
                 */
                private Integer status;

                private String remark;
                //商家退单审核 备注
                private String decisionReason;

                //创建时间
                private String createTime;

            }

            @NoArgsConstructor
            @Data
            public static class AccountBean {
                /**
                 * accountId : 121347407098150912
                 * name : 满减折扣
                 * number : 1
                 * oaid :
                 * orderId : 119108155383846159
                 * price : -700
                 * sequence : 0
                 * type : 2
                 */
                private String accountId;
                private String name;
                private Integer number;
                private String oaid;
                /**
                 * 订单编号
                 */
                private String orderId;
                /**
                 * 优惠金额
                 */
                private Long price;
                private Integer sequence;
                /**
                 * 结算对象类型  1 运费 2折扣 3包装费 4积分 5 优惠券 6线下支付 7 微信 8 支付宝 9 商户金额
                 */
                private Integer type;
                /**
                 * 自定义对象
                 */
                private String addInfo;
            }
        }
    }
}
