package cn.freemud.service.impl

import cn.freemud.adapter.ActivityAdapter
import cn.freemud.adapter.CouponAdapter
import cn.freemud.adapter.StoreItemAdapter
import cn.freemud.entities.dto.GetCouponDetailResponseDto
import cn.freemud.entities.dto.ProductBaseResponse
import cn.freemud.entities.dto.ProductInfosDto
import cn.freemud.entities.dto.calculate.ActivityCalculationDiscountResponseDto
import cn.freemud.entities.dto.product.CheckCartRequest
import cn.freemud.entities.dto.product.ValiadShopProductResponse
import cn.freemud.entities.dto.product.ValiadShopProductResult
import cn.freemud.entities.vo.AddShoppingCartGoodsRequestVo
import cn.freemud.entities.vo.CartGoods
import cn.freemud.entities.vo.GetShoppingCartGoodsApportionRequestVo
import cn.freemud.service.CommonService
import cn.freemud.service.impl.calculate.CalculationSharingDiscountService
import cn.freemud.service.thirdparty.ActivityClient
import cn.freemud.service.thirdparty.CouponOnlineClient
import cn.freemud.service.thirdparty.ProductClient
import com.alibaba.fastjson.JSON
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager
import spock.lang.Specification

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/3/3 10:04
 * @description : 
 */
class ShoppingCartNewServiceImplTest extends Specification {

    def shoppingCartNewServiceImpl = new ShoppingCartNewServiceImpl()
    def assortmentSdkService = Mock(AssortmentSdkService.class)
    def customerInfoManager = Mock(AssortmentCustomerInfoManager.class)
    def productService = Mock(ProductServiceImpl.class)
    def productClient = Mock(ProductClient.class)
    def activityAdapter = new ActivityAdapter()
    def couponAdapter = new CouponAdapter()
    def activityClient = Mock(ActivityClient.class)
    def couponOnlineClient = Mock(CouponOnlineClient.class)
    def commonService = Mock(CommonService.class)
    def productServiceImpl = new ProductServiceImpl()
    def sharingDiscountService = new CalculationSharingDiscountService()
    def couponService = new CouponServiceImpl()
    def itemService = new ItemServiceImpl()
    def storeItemAdapter = new StoreItemAdapter()

    void setup() {
        shoppingCartNewServiceImpl.customerInfoManager = customerInfoManager
        shoppingCartNewServiceImpl.productService = productService
        shoppingCartNewServiceImpl.assortmentSdkService = assortmentSdkService
        shoppingCartNewServiceImpl.activityAdapter = activityAdapter
        shoppingCartNewServiceImpl.couponAdapter = couponAdapter
        shoppingCartNewServiceImpl.couponService = couponService
        shoppingCartNewServiceImpl.commonService = commonService
        // fisherman  测试过程中, 需要测试 新老算价需要自己 控制开关
        shoppingCartNewServiceImpl.newSharing = "{\"type\":1,\"grayList\":\"2581\",\"enable\":true}"
        shoppingCartNewServiceImpl.activityClient = activityClient
        shoppingCartNewServiceImpl.sharingDiscountService = sharingDiscountService
        productServiceImpl.productClient = productClient
        sharingDiscountService.activityClient = activityClient
        couponService.couponOnlineClient = couponOnlineClient
        couponService.commonService = commonService
        couponService.itemService = itemService
        couponService.storeItemClient = productClient
        itemService.storeItemAdapter = storeItemAdapter
        itemService.storeItemClient = productClient

    }



    def "测试 /getShoppingCartGoodsApportion 订单调用购物车获取结算金额"() {
        given: "参数设置"
        def getShoppingCartGoodsApportionRequestVo = JSON.parseObject("{\"shoppingCartInfoRequestVo\":{\"activityCode\":\"G1643164091158349\",\"buyType\":0,\"couponCode\":\"88709227085491207040\",\"couponCodes\":[{\"activityCode\":\"G1643164091158349\",\"couponCode\":\"88709227085491207040\",\"couponType\":7,\"discountAmount\":800,\"index\":1}],\"flag\":0,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"2581\",\"reachStoreType\":5,\"sendGoods\":[],\"sessionId\":\"eac53a53f8ae62def7f40cb1e47a1bd9791d95a8\",\"shopId\":\"229830\",\"trackingNo\":\"8283bc4c7e5f4bbb8b357e3c0bef7183\",\"useCouponFlag\":1,\"useCustomerScore\":2,\"version\":\"2.0.60.6\"}}"
                , GetShoppingCartGoodsApportionRequestVo.class)
        def premiumExchangeActivity = getShoppingCartGoodsApportionRequestVo.getPremiumExchangeActivity()
        def shoppingCartInfoRequestVo = getShoppingCartGoodsApportionRequestVo.getShoppingCartInfoRequestVo()

        def customerInfoVo = JSON.parseObject("{\"accessToken\":\"\",\"alipayUserId\":\"\",\"appId\":\"wx3f7ca0c75b213380\",\"appSecret\":\"\",\"appsecret\":\"\",\"channel\":\"1\",\"customerId\":\"\",\"devBrand\":\"\",\"devModel\":\"\",\"iappId\":\"7\",\"memberId\":\"3614319825989629832\",\"mobile\":\"17327190802\",\"newMember\":false,\"nickName\":\"SWEET SUGA\",\"openId\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"openid\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"partnerId\":\"2581\",\"photoUrl\":\"https://thirdwx.qlogo.cn/mmopen/vi_32/zahIlicTNSM0IA0qjOryv6s0SzIhlwW9EpQKvL63GbPhBwficMAibDohDEibSCQU0I5KohibIpp0yL57TWRcVKrRH2A/132\",\"registerTime\":\"2021-02-26 14:10:26\",\"sessionId\":\"eac53a53f8ae62def7f40cb1e47a1bd9791d95a8\",\"sessionKey\":\"GCyyapzbBSM4yXh9AduGOw==\",\"session_key\":\"GCyyapzbBSM4yXh9AduGOw==\",\"storeId\":\"\",\"tableNumber\":\"\",\"thirdPartyMemberID\":\"\",\"thirdPartyPartnerID\":\"\",\"unionId\":\"o7cEm68JPFhbrzqb0a0BcQE-dDVA\",\"wxAppId\":\"wx3f7ca0c75b213380\",\"wxAppid\":\"wx3f7ca0c75b213380\"}"
                , AssortmentCustomerInfoVo.class)


        def activityCalculationDiscountResponseDto = JSON.parseObject("{\"msg\":\"成功\",\"result\":{\"apportionGoods\":[{\"apportionAmount\":0,\"apportionDetails\":[],\"cartGoodsUid\":\"6dabf892-901b-40b8-a985-5c097c905678\",\"goodsId\":\"201889968054882060\",\"goodsQuantity\":1,\"nowPrice\":500,\"originalPrice\":500},{\"apportionAmount\":800,\"apportionDetails\":[{\"activityApportionAmount\":800,\"activityCode\":\"88709227085491207040\",\"activityName\":\"鸡米花买一送一券\",\"activityType\":330,\"apportionType\":-1}],\"cartGoodsUid\":\"d0fb5162-2f51-4e8c-9e61-fadade791483\",\"goodsId\":\"201889966261817090\",\"goodsQuantity\":1,\"nowPrice\":0,\"originalPrice\":800},{\"apportionAmount\":0,\"apportionDetails\":[],\"cartGoodsUid\":\"d0fb5162-2f51-4e8c-9e61-fadade791483\",\"goodsId\":\"201889966261817090\",\"goodsQuantity\":1,\"nowPrice\":800,\"originalPrice\":800}],\"couponDiscounts\":[{\"activityName\":\"鸡米花买一送一券\",\"activityType\":330,\"couponCode\":\"88709227085491207040\",\"discountAmount\":800}],\"discounts\":[{\"activityName\":\"鸡米花买一送一券\",\"discount\":800}],\"goods\":[{\"cartGoodType\":0,\"cartGoodsUid\":\"6dabf892-901b-40b8-a985-5c097c905678\",\"discountAmount\":0,\"discounts\":[],\"gift\":false,\"goodsId\":\"201889968054882060\",\"goodsQuantity\":1,\"meal\":false,\"nowPrice\":500,\"originalPrice\":500,\"realAmount\":500,\"score\":0,\"smallMaterial\":[]},{\"actualGoodsNumber\":1,\"cartGoodType\":0,\"cartGoodsUid\":\"d0fb5162-2f51-4e8c-9e61-fadade791483\",\"discountAmount\":800,\"discounts\":[{\"activityCode\":\"88709227085491207040\",\"activityName\":\"鸡米花买一送一券\",\"actualGoodsNumber\":1,\"addOnQuantity\":0,\"discount\":800,\"goodsId\":\"201889966261817090\",\"signleDiscount\":800,\"type\":330}],\"gift\":false,\"goodsId\":\"201889966261817090\",\"goodsQuantity\":2,\"meal\":false,\"nowPrice\":800,\"originalPrice\":800,\"realAmount\":800,\"score\":0,\"smallMaterial\":[]}],\"isScoreLimit\":0,\"nightDistributionFee\":0,\"originalTotalAmount\":2100,\"stocks\":[],\"totalAmount\":1300,\"totalDiscountAmount\":800,\"v3Promotion\":false},\"statusCode\":\"100\",\"ver\":1}"
                , ActivityCalculationDiscountResponseDto.class)

        def goodList = JSON.parseArray("[{\"addCartTime\":1646286585880,\"amount\":800,\"canUseCoupon\":0,\"cartGoodsUid\":\"b8eca7b4-8627-4726-8560-b1d9f74a1c8b\",\"couponCode\":\"88709227085491207040\",\"createTimeMili\":1646286585880,\"extra\":[],\"goodsId\":\"spq88709227085491207040\",\"goodsType\":10,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isUseMonthCard\":0,\"linkedId\":\"\",\"originalAmount\":0,\"originalPrice\":800,\"originalProductType\":1,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1619081297921.jpg\",\"productComboList\":[],\"productGroupList\":[],\"productMaterialList\":[],\"qty\":2,\"skuId\":\"201889966261817090\",\"skuName\":\"鸡米花T\",\"spuId\":\"201889966261817090\",\"stockLimit\":false,\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"addCartTime\":1646286600492,\"amount\":500,\"canUseCoupon\":1,\"cartGoodsUid\":\"87653424-e6ef-45c7-ad84-2ebc777cccc9\",\"categoryName\":\"缤纷小食\",\"classificationForeignName\":\"正价单品\",\"classificationId\":\"0102\",\"classificationName\":\"正价单品\",\"createTimeMili\":1646286600492,\"customerCode\":\"hn80180054\",\"finalPrice\":500,\"foreignName\":\"\",\"goodsId\":\"201889968054882060\",\"goodsType\":5,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isUseMonthCard\":0,\"linkedId\":\"\",\"materialAmount\":0,\"memberDiscount\":100,\"name\":\"元气鸡排T\",\"originalAmount\":500,\"originalMaterialAmount\":0,\"originalPrice\":500,\"originalProductType\":1,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1619082050722.jpg\",\"productComboList\":[],\"productGroupList\":[],\"productMaterialList\":[],\"qty\":1,\"riseSell\":1,\"singleOrder\":0,\"skuForeignName\":\"\",\"skuId\":\"\",\"skuName\":\"元气鸡排T\",\"spuForeignName\":\"\",\"spuId\":\"201889968054882060\",\"spuName\":\"元气鸡排T\",\"stockLimit\":false,\"subForeignName\":\"\",\"subName\":\"\",\"tax\":0.01,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false}]"
                , CartGoods.class)

        def responseDto = JSON.parseObject("{\"details\":[{\"active\":{\"ActiveCode\":\"G1643164091158349\",\"ActiveDesc\":\"\\\"优惠券规则：\\n\\n券有效时间：领取后当日生效，有效期45天（具体以门店营业时间为准）\\n\\n使用范围：全国范围内已上线华莱士官方点餐小程序的华莱士门店（湖南省、湖北省、吉林省、新疆自治区除外，广东省、河北省、安徽省、海南省、北京市部分门店可用）\\n\\n活动规则：\\n1、在券有效期内，可凭本券在“华莱士官方点餐”小程序获得一次鸡米花买一送一权益。\\n2、本代金券仅限在“华莱士官方点餐”小程序上使用，与特价折扣商品不可同享，且不支持任何形式的核销后退款、变现、找零或转让。\\n3、产品规格以门店售卖为准。\\n4、 若因不可抗力因素致使本活动因故无法进行，主办方将在法律允许范围内取消、终止、修改或暂停本活动，且不承担任何违约或赔偿责任，尽管有上述约定，主办方将采取合理行动积极促使活动恢复正常。\\n如有疑问，可联系电话：4008899096。\\\"\\n\",\"ActiveId\":158770339,\"ActiveName\":\"鸡米花买一送一券\",\"AppId\":\"{\\\"apps\\\":[{\\\"appId\\\":\\\"wx3f7ca0c75b213380\\\",\\\"appName\\\":\\\"华莱士官方点餐\\\"},{\\\"appId\\\":\\\"2021002109662866\\\",\\\"appName\\\":\\\"华莱士官方点餐支付宝\\\"}]}\",\"BuyCount\":2,\"CreateDate\":\"2022-01-26 10:28:11\",\"CreateUser\":\"Rena\",\"DailyRedeemTimes\":1,\"EBCode\":\"\",\"Effective\":45,\"EffectiveEnd\":1676476799000,\"EffectiveStart\":1643126400000,\"EndDate\":\"2032-01-24 15:35:23\",\"EndString\":\"2032-01-24 15:35:23\",\"FromDayEffective\":0,\"GiftCount\":1,\"Inventory\":0,\"LastEditDate\":\"2022-03-02 13:53:16\",\"LastEditUser\":\"Rena\",\"LimitType\":1,\"MaxDiscount\":0,\"MaxRedeemTimes\":1,\"MerchantDiscountPrice\":0.00,\"MinAmount\":0.00,\"NoticeType\":0,\"OriginalPrice\":0,\"OtherDiscountPrice\":0.00,\"PartnerID\":2581,\"PlatformDiscountPrice\":0.00,\"RedeemChannel\":\"pickup,delivery\",\"Remain\":0,\"SalePrice\":0,\"StartDate\":\"2022-01-24 15:35:23\",\"StartString\":\"2022-01-24 15:35:23\",\"State\":1,\"Type\":7,\"VoucherFaceValue\":0.00,\"couponKind\":0,\"createType\":0,\"exemptionRule\":21,\"isDonate\":0,\"isMarketingTransfer\":0,\"logo\":\"https://picture.sandload.cn/1643095730650.jpg\",\"productScopeDesc\":\"全场通用\",\"promotionSharing\":0,\"remark\":\"\",\"storeScopeDesc\":\"全门店通用\"},\"activeCode\":\"G1643164091158349\",\"activeOrganizes\":[],\"activeProduct\":[{\"ActiveID\":158770339,\"Amount\":2,\"ID\":101092250,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210794556366562343\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210794556366562343},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":102707818,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202721754691430443\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202721754691430443},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":106896658,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210401734183578909\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210401734183578909},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":108664259,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201892530732737281\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201892530732737281},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":109930762,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"196181856362935850\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":196181856362935850},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":110136846,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"205739042253494553\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":205739042253494553},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":111281004,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202543005601654827\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202543005601654827},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":114626445,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201893297779668538\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201893297779668538},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":115395628,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202522421465524768\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202522421465524768},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":115820199,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"200624575557483286\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":200624575557483286},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":117240395,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202011967089649173\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202011967089649173},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":117999939,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201889966261817090\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201889966261817090},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":123936211,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201271922131126554\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201271922131126554},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":124066993,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210802942716994352\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210802942716994352},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":125896835,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"205705620076274750\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":205705620076274750},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":126390048,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201274763745872130\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201274763745872130},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":126672465,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202529859526748216\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202529859526748216},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":127065845,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202539418023664675\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202539418023664675},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":128117060,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210243929020483597\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210243929020483597},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":129635517,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"206150230788338465\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":206150230788338465},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":134711312,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"200463475075688706\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":200463475075688706},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":136288590,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201897415072052794\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201897415072052794},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":137630535,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202540819597675521\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202540819597675521},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":140530255,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201897810603308572\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201897810603308572},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":146050161,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"208982785000576831\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":208982785000576831},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":147751575,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202523893002430477\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202523893002430477},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":148992322,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"218142359735548461\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":218142359735548461},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":156830621,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"196180894333253140\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":196180894333253140},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":160705326,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202538605917268002\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202538605917268002},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":162463116,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202529566968801295\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202529566968801295},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":169597458,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"209226684733332798\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":209226684733332798},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":171307549,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"213420606371245629\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":213420606371245629},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":173136602,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202526680993012751\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202526680993012751},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":176003576,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202526989498738731\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202526989498738731},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":176541223,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202530381634771974\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202530381634771974},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":178377691,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202809932735654450\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202809932735654450},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":180645301,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201276161287901451\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201276161287901451},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":184234583,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"205116588443264314\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":205116588443264314},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":186250294,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210240193529248544\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210240193529248544},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":187829982,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202985175152355391\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202985175152355391},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":188803312,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201890450460747316\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201890450460747316},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":189633316,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201904128631273001\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201904128631273001},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":199438172,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210137445573931030\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210137445573931030},{\"ActiveID\":158770339,\"Amount\":1,\"ID\":1724328479,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"233056712980957721\",\"Remain\":0,\"exchangePrice\":0.00,\"kgdProductId\":233056712980957721}],\"activeProductSetting\":[],\"activeRedeemTimeIntervalList\":[],\"activeRestrictionVOS\":[],\"code\":\"88709227085491207040\",\"create_time\":\"2022-02-20 15:10:42\",\"limitStoreId\":null,\"lockStatus\":false,\"minAmount\":\"0\",\"sendReason\":\"手动送券，SWEET SUGA，17327190802\",\"status\":0,\"storelimit\":0,\"storeChannelLimit\":0,\"storeLimitLevel\":1,\"title\":\"鸡米花买一送一券\",\"today_available_times\":1,\"total_available_times\":1,\"type\":7,\"valid_ends\":\"2022-04-05 23:59:59\",\"valid_start\":\"2022-02-20 00:00:00\"}],\"errors\":[],\"result\":1,\"statusCode\":0,\"ver\":1}"
                , GetCouponDetailResponseDto.class)

        def checkCartRequest = new CheckCartRequest()
        checkCartRequest.setCartGoodsList(goodList)

        def hasRequiredProducts = false


        def productInfosDto = JSON.parseObject("{\"data\":{\"count\":1,\"products\":[{\"barcode\":\"\",\"brandId\":\"\",\"brandName\":\"\",\"category\":\"0102\",\"categoryName\":\"正价单品\",\"companyId\":\"2581\",\"customerCode\":\"hn80016\",\"finalPrice\":800,\"foreignName\":\"\",\"isSkuProduct\":0,\"labelNames\":[{\"foreignName\":\"\",\"id\":\"201728920800923959\",\"name\":\"辣味🌶🌶\",\"partnerId\":\"2581\",\"productList\":[],\"storeId\":\"\",\"type\":\"0\"}],\"linkedId\":\"\",\"maxNum\":0,\"minNum\":0,\"name\":\"鸡米花T\",\"originalPrice\":800,\"packPrice\":0,\"picture\":\"https://picture.sandload.cn/1619081297921.jpg\",\"pid\":\"201889966261817090\",\"pknumber\":1,\"productAttributeGroupList\":[],\"productBindingCouponTypes\":[],\"productGroupList\":[],\"productPictureList\":[{\"sequence\":\"0\",\"type\":\"default\",\"url\":\"https://picture.sandload.cn/1619081297921.jpg\"}],\"productSpecification\":[],\"productionLocation\":\"\",\"remark\":\"一口接一口，口口留香。\",\"saleCount\":0,\"sellTimeList\":[],\"sequence\":0,\"singleOrder\":0,\"skuList\":[],\"skuSpecValues\":[],\"sourceChannel\":\"\",\"specProductId\":\"\",\"specification\":\"\",\"specificationGroupList\":[],\"specificationList\":[],\"status\":2,\"stock\":9999,\"stockLimit\":2,\"tax\":0.01,\"taxId\":\"\",\"type\":1,\"unit\":\"\",\"updateStatus\":0,\"valid\":true,\"version\":0,\"weight\":0.0,\"weightType\":0}]},\"errcode\":100,\"errmsg\":\"成功\"}"
                , ProductInfosDto.class)

        ProductBaseResponse productBaseResponse = new ProductBaseResponse();
        def successList = JSON.parseArray("[{\"productType\":{\"additionalGroupList\":[],\"appIdList\":[],\"barcode\":\"\",\"brandId\":\"\",\"brandName\":\"\",\"businessNo\":\"\",\"businessType\":\"\",\"category\":\"0102\",\"categoryName\":\"正价单品\",\"comboType\":0,\"companyId\":\"2581\",\"completeFlag\":2,\"customerCode\":\"hn80016\",\"customerName\":\"\",\"detailImages\":[],\"detailText\":\" \",\"finalPrice\":800,\"foreignDetailText\":\"\",\"foreignName\":\"\",\"foreignRawMaterial\":\"\",\"foreignRemark\":\"\",\"foreignUnit\":\"\",\"isDishware\":0,\"isLimitNumProduct\":0,\"isRecommend\":0,\"isSkuProduct\":0,\"isUpdateSetMeal\":1,\"labelNames\":[{\"backgroundColor\":\"\",\"endTime\":\"\",\"fontColor\":\"\",\"foreignName\":\"\",\"foreverShow\":0,\"id\":201728920800923959,\"isVisible\":1,\"labelDetail\":\"\",\"labelForm\":0,\"name\":\"辣味🌶🌶\",\"options\":\"\",\"partnerId\":\"2581\",\"productList\":[],\"startTime\":\"\",\"status\":0,\"storeId\":\"\",\"type\":\"0\"}],\"linkedId\":\"\",\"maxLimitNumber\":0,\"maxNum\":0,\"maxRestrictionQty\":0,\"memberDiscount\":100,\"memberPrice\":0,\"minLimitNumber\":0,\"minNum\":0,\"minRestrictionQty\":0,\"name\":\"鸡米花T\",\"openMemberDiscount\":0,\"options\":\"\",\"originalPrice\":800,\"otherDesc\":\"\",\"packPrice\":0,\"partnerStatus\":2,\"picture\":\"https://picture.sandload.cn/1619081297921.jpg\",\"pid\":\"201889966261817090\",\"pknumber\":1,\"priceOrigin\":\"\",\"priceSource\":2,\"productAttributeGroupList\":[],\"productBindingCouponTypes\":[],\"productCategoryDetailList\":[],\"productCode\":\"010200001\",\"productComboList\":[],\"productGroupList\":[],\"productPictureList\":[{\"sequence\":0,\"type\":\"default\",\"url\":\"https://picture.sandload.cn/1619081297921.jpg\"}],\"productSpecification\":[],\"productionLocation\":\"\",\"rawMaterial\":\"\",\"remark\":\"一口接一口，口口留香。\",\"riseSell\":1,\"saleCount\":0,\"salesChannel\":\"\",\"sellTimeList\":[],\"sellTimeMonthList\":[],\"sellTimeRangeList\":[],\"sellTimeValid\":true,\"sequence\":0,\"shopLongTermSalesVolume\":0,\"shopShortTermSalesVolume\":0,\"singleOrder\":0,\"skuList\":[],\"skuSpecValues\":[],\"sourceChannel\":\"\",\"specProductId\":\"\",\"specification\":\"\",\"specificationGroupList\":[],\"specificationList\":[],\"standardGoodsFlag\":2,\"status\":2,\"stock\":9999,\"stockLimit\":2,\"storeCondition\":\"\",\"storeProductName\":\"\",\"tax\":0.01,\"taxId\":\"\",\"trueOriginalPrice\":0,\"type\":1,\"unit\":\"\",\"valid\":true,\"version\":0,\"weight\":0.0,\"weightType\":0},\"skuId\":\"201889966261817090\",\"spuId\":\"201889966261817090\",\"subProductTypeMap\":null,\"uuid\":\"3bad199e-43a3-44bc-a42b-333415f09a58\"}]"
                , ValiadShopProductResult.class)
        ValiadShopProductResponse valiadShopProductResponse = new ValiadShopProductResponse();
        valiadShopProductResponse.setSuccessList(successList)
        valiadShopProductResponse.setFailureList(new ArrayList<ValiadShopProductResult>())
        productBaseResponse.setData(valiadShopProductResponse)

        and: "调三方反馈参数 为自己的参数对象 "
        customerInfoManager.getCustomerInfoByObject("eac53a53f8ae62def7f40cb1e47a1bd9791d95a8") >> customerInfoVo
        assortmentSdkService.getShoppingCart(_, _, _, _, _, _, _) >> goodList
        productService.hasRequiredProducts(_, _, _, _) >> hasRequiredProducts
        assortmentSdkService.checkShoppingCartSdk(_, _, _, _, _, _, _, _) >> checkCartRequest
        activityClient.calculationDiscount(_) >> activityCalculationDiscountResponseDto
        commonService.getOrgIdsAsString(_, _) >> null
        commonService.getOrgIdsForCoupon(_, _) >> ["1e906bab-1800-4b00-8e36-29049d7f4efc", "391cec83-2b60-49a9-af2c-d8d6a813ce72", "16dc665e-8e03-41a8-83ae-95e92666d266"]
        couponOnlineClient.getCouponDetails(_) >> responseDto
        productClient.listProductInfos(_) >> productInfosDto
        productClient.validateShopProduct(_) >> productBaseResponse
        when: "调用方法逻辑"

        //   测试过程中, 需要测试 新老算价需要自己 控制开关
        def response = shoppingCartNewServiceImpl.getShoppingCartGoods(shoppingCartInfoRequestVo, premiumExchangeActivity)

        then: "验证 返回结果"
        with(response) {
            code == "100"
            message == "success"
        }

    }


}
