package cn.freemud.management.service;

import cn.freemud.management.adapter.MessagePushAdapter;
import cn.freemud.management.enums.DeliveryStatus;
import cn.freemud.management.enums.MessageCenterCmdType;
import cn.freemud.management.enums.OperateType;
import cn.freemud.management.enums.OrderSource;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto;
import com.freemud.application.sdk.api.structure.request.PushMessageNoticeDto;
import com.freemud.application.sdk.api.structure.service.MessageCenterClient;
import com.freemud.sdk.api.assortment.message.request.MessagePushOrderTemplateRequest;
import com.freemud.sdk.api.assortment.message.request.MessageTemplateRequest;
import com.freemud.sdk.api.assortment.message.service.IMessageTemplatePushService;
import com.freemud.sdk.api.assortment.order.request.order.AssortmentUpdateDeliveryAbnormalRequest;
import com.freemud.sdk.api.assortment.order.request.order.BaseQueryOrderRequest;
import com.freemud.sdk.api.assortment.order.request.order.UpdateDeliveryInfoByIdRequest;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrderByIdResponse;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class OrderBaseService {

    private static final int SUCCESS = 100;

    @Autowired
    private OrderCenterSdkService orderCenterSdkService;
    @Autowired
    private MessageCenterClient messageCenterClient;
    @Autowired
    private MessagePushAdapter messagePushAdapter;
    @Autowired
    @Qualifier("messageTemplatePushOrderService")
    private IMessageTemplatePushService<MessagePushOrderTemplateRequest> messageTemplatePushService;

    public QueryOrdersResponse.DataBean.OrderBean getByOrderCode(String orderCode) {
        BaseQueryOrderRequest queryRequest = new BaseQueryOrderRequest();
        queryRequest.setOrderId(orderCode);
        QueryOrderByIdResponse response = orderCenterSdkService.queryOrderById(queryRequest);
        if (ObjectUtils.notEqual(response.getErrcode(), SUCCESS) || response.getData() == null) {
            return null;
        }
        return response.getData();
    }

    public void sendMessage(QueryOrdersResponse.DataBean.OrderBean orderBean, OperateType opType, String reason) {
        //发送消息到pos消息中心
        PushMessageNoticeDto pushMessageNoticeDto1 = null;
        try {
            pushMessageNoticeDto1 = messagePushAdapter.convent2PushMessageNoticeDto1(orderBean);
            messageCenterClient.createMessage(pushMessageNoticeDto1, LogThreadLocal.getTrackingNo());
        } catch (Exception e) {
            ErrorLog.printErrorLog("sendMessageCenterError", "", pushMessageNoticeDto1, e);
        }
        //发送微信模板消息
        if (orderBean.getExtInfo() != null && !(OrderSource.SAAS.getSource().equals(orderBean.getSource()) || OrderSource.ALIPAY.getSource().equals(orderBean.getSource()))) {
            return;
        }
        MessageTemplateRequest<MessagePushOrderTemplateRequest> messageTemplateRequest = null;
        try {
            messageTemplateRequest = messagePushAdapter.convent2MessageTemplateRequest(orderBean, reason, opType);
            if (messageTemplateRequest!=null && messageTemplateRequest.getMessageEventType() != null) {
                this.messageTemplatePushService.sendTemplateMsg(messageTemplateRequest);
            }
        } catch (Exception e) {
            ErrorLog.printErrorLog("sendTemplateMsgError", "", messageTemplateRequest, e);
        }


    }

    /**
     * 创建配送单一车 -> 更新订单为异常单
     *
     * @param partnerId
     * @param orderCode
     * @param deliveryId
     */
    public void updateDeliveryAbnormal(String partnerId, String orderCode, String deliveryId, String operator) {
        AssortmentUpdateDeliveryAbnormalRequest request = AssortmentUpdateDeliveryAbnormalRequest.builder()
                .abnormalDesc("配送异常")
                .deliveryId(deliveryId)
                .orderCode(orderCode)
                .partnerId(partnerId)
                .operator(StringUtils.isNotBlank(operator) ? operator : "sys")
                .build();
        orderCenterSdkService.updateDeliveryAbnormal(request);
    }

    /**
     * 创建配送单成功后 -> 更新订单配送信息
     *
     * @param orderCode
     * @param deliveryId
     */
    public void updateDeliverySuccess(String orderCode, String deliveryId, String operator) {
        // 创建配送单成功
        UpdateDeliveryInfoByIdRequest updateDeliveryInfoByIdRequest = new UpdateDeliveryInfoByIdRequest();
        updateDeliveryInfoByIdRequest.setDeliveryId(deliveryId);
        updateDeliveryInfoByIdRequest.setOrderId(orderCode);
        updateDeliveryInfoByIdRequest.setOrderSubState(DeliveryStatus.WATINGORDER.getCode());
        operator = StringUtils.isNotBlank(operator) ? operator : "sys";
        updateDeliveryInfoByIdRequest.setOperator(operator);
        orderCenterSdkService.updateDeliveryInfoById(updateDeliveryInfoByIdRequest);
    }
}
